/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction.claim;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.config.AuctionBackendMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionClaimService {
    private final Map<UUID, List<ItemStack>> pendingReturns;
    private final AuctionBackendMessages backendMessages;
    private final String CLAIM_COMMAND = "/auction claim";

    public void returnListingItem(AuctionListing listing, Map<UUID, List<ItemStack>> pendingReturns) {
        Player seller;
        if (listing == null) {
            return;
        }
        ItemStack item = listing.item();
        if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            return;
        }
        ItemStack itemToReturn = item.clone();
        UUID sellerId = listing.sellerId();
        Player player = seller = sellerId != null ? Bukkit.getPlayer((UUID)sellerId) : null;
        if (seller != null && seller.isOnline()) {
            HashMap leftover = seller.getInventory().addItem(new ItemStack[]{itemToReturn});
            if (leftover.isEmpty()) {
                seller.sendMessage("Your auction item has been returned to your inventory.");
                return;
            }
            for (ItemStack remainder : leftover.values()) {
                if (remainder == null || remainder.getType() == Material.AIR || remainder.getAmount() <= 0) continue;
                this.storeReturnItem(sellerId, remainder, pendingReturns);
            }
            seller.sendMessage("Some items could not fit in your inventory and were stored for later claim.");
            return;
        }
        this.storeReturnItem(sellerId, itemToReturn, pendingReturns);
    }

    public boolean hasInventorySpace(Player player, ItemStack item) {
        if (item == null) {
            return false;
        }
        int remaining = item.getAmount();
        int stackLimit = Math.min(item.getMaxStackSize(), player.getInventory().getMaxStackSize());
        for (ItemStack content : player.getInventory().getStorageContents()) {
            if (remaining <= 0) break;
            if (content == null || content.getType() == Material.AIR) {
                remaining -= stackLimit;
                continue;
            }
            if (!content.isSimilar(item)) continue;
            int contentLimit = Math.min(stackLimit, content.getMaxStackSize());
            remaining -= Math.max(0, contentLimit - content.getAmount());
        }
        return remaining <= 0;
    }

    public boolean claimListing(String listingId, Map<String, AuctionListing> listings, Map<UUID, List<ItemStack>> pendingReturns) {
        if (listingId == null || listingId.isEmpty()) {
            return false;
        }
        AuctionListing listing = listings.remove(listingId);
        return listing != null;
    }

    public void storeReturnItem(UUID playerId, ItemStack item, Map<UUID, List<ItemStack>> pendingReturns) {
        if (playerId == null || item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            return;
        }
        pendingReturns.compute(playerId, (uuid, existing) -> {
            ArrayList<ItemStack> updated = existing != null ? new ArrayList<ItemStack>((Collection<ItemStack>)existing) : new ArrayList();
            updated.add(item.clone());
            return updated;
        });
    }

    public void deliverOrderItem(AuctionOrder order, ItemStack item, Map<UUID, List<ItemStack>> pendingReturns) {
        Player buyer;
        if (order == null || item == null || item.getType() == Material.AIR || item.getAmount() <= 0) {
            return;
        }
        ItemStack toDeliver = item.clone();
        UUID buyerId = order.buyerId();
        Player player = buyer = buyerId != null ? Bukkit.getPlayer((UUID)buyerId) : null;
        if (buyer != null && buyer.isOnline()) {
            HashMap leftover = buyer.getInventory().addItem(new ItemStack[]{toDeliver});
            int storedAmount = 0;
            if (!leftover.isEmpty()) {
                for (ItemStack remainder : leftover.values()) {
                    if (remainder == null || remainder.getType() == Material.AIR || remainder.getAmount() <= 0) continue;
                    storedAmount += remainder.getAmount();
                    this.storeReturnItem(buyerId, remainder.clone(), pendingReturns);
                }
            }
            return;
        }
        this.storeReturnItem(buyerId, toDeliver, pendingReturns);
    }

    public AuctionClaimService(Map<UUID, List<ItemStack>> pendingReturns, AuctionBackendMessages backendMessages) {
        this.pendingReturns = pendingReturns;
        this.backendMessages = backendMessages;
    }

    public void handlePlayerLogin(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return;
        }
        int totalItems = this.countItemAmount(stored);
        if (totalItems <= 0) {
            this.pendingReturns.remove(playerId);
            return;
        }
        player.sendMessage(this.formatMessage(this.backendMessages.claim().reminder(), "total", String.valueOf(totalItems), "returned-suffix", this.pluralSuffix(totalItems), "command", "/auction claim"));
    }

    public int countPendingReturnItems(UUID playerId) {
        if (playerId == null) {
            return 0;
        }
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        return this.countItemAmount(stored);
    }

    public AuctionOperationResult claimReturnItems(Player player) {
        String message;
        if (player == null) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().playersOnly(), new String[0]));
        }
        UUID playerId = player.getUniqueId();
        List<ItemStack> stored = this.pendingReturns.get(playerId);
        if (stored == null || stored.isEmpty()) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().noneAvailable(), new String[0]));
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        int claimedAmount = 0;
        int availableAmount = 0;
        for (ItemStack storedItem : stored) {
            if (storedItem == null || storedItem.getType() == Material.AIR || storedItem.getAmount() <= 0) continue;
            ItemStack toGive = storedItem.clone();
            availableAmount += toGive.getAmount();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{toGive});
            if (leftover.isEmpty()) {
                claimedAmount += toGive.getAmount();
                continue;
            }
            int leftoverAmount = 0;
            for (ItemStack remainder : leftover.values()) {
                if (remainder == null || remainder.getType() == Material.AIR || remainder.getAmount() <= 0) continue;
                leftoverAmount += remainder.getAmount();
                remaining.add(remainder.clone());
            }
            claimedAmount += Math.max(0, toGive.getAmount() - leftoverAmount);
        }
        if (availableAmount <= 0) {
            this.pendingReturns.remove(playerId);
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().noneAvailable(), new String[0]));
        }
        if (remaining.isEmpty()) {
            this.pendingReturns.remove(playerId);
        } else {
            this.pendingReturns.put(playerId, remaining);
        }
        if (claimedAmount <= 0) {
            return AuctionOperationResult.failure(this.formatMessage(this.backendMessages.claim().inventoryFull(), new String[0]));
        }
        int remainingAmount = this.countItemAmount(remaining);
        if (remainingAmount > 0) {
            message = this.formatMessage(this.backendMessages.claim().partial(), "claimed", String.valueOf(claimedAmount), "claimed-suffix", this.pluralSuffix(claimedAmount), "remaining", String.valueOf(remainingAmount), "remaining-suffix", this.pluralSuffix(remainingAmount));
            return AuctionOperationResult.success(message);
        }
        message = this.formatMessage(this.backendMessages.claim().complete(), "claimed", String.valueOf(claimedAmount), "claimed-suffix", this.pluralSuffix(claimedAmount));
        return AuctionOperationResult.success(message);
    }

    private int countItemAmount(List<ItemStack> items) {
        if (items == null || items.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : items) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            total += Math.max(0, stack.getAmount());
        }
        return total;
    }

    private String formatMessage(String template, String ... replacements) {
        if (template == null || template.isEmpty()) {
            return "";
        }
        String formatted = template;
        int i = 0;
        while (i + 1 < replacements.length) {
            String key = replacements[i];
            String value = replacements[i + 1];
            formatted = formatted.replace("{" + key + "}", value != null ? value : "");
            i += 2;
        }
        return this.colorize(formatted);
    }

    private String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String pluralSuffix(int amount) {
        return amount == 1 ? "" : "s";
    }
}

