/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction;

import com.skyblockexp.ezauction.bootstrap.PluginConfigs;
import com.skyblockexp.ezauction.bootstrap.PluginRegistry;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzAuctionPlugin
extends JavaPlugin {
    public static final String DISPLAY_NAME = "EzAuction";
    private PluginRegistry registry;

    public void onEnable() {
        this.logStartupHeader();
        this.ensureDefaultConfig();
        this.registry = new PluginRegistry(this);
        this.registry.enableAll();
        this.getLogger().info("EzAuction plugin enabled.");
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        if (this.registry != null) {
            this.registry.disableAll();
            this.registry = null;
        }
        this.getLogger().info("EzAuction plugin disabled.");
    }

    private void ensureDefaultConfig() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.getLogger().log(Level.WARNING, "Failed to create plugin data folder at {0}.", dataFolder);
        }
        for (String resourcePath : PluginConfigs.CONFIG_FILES) {
            this.ensureConfigFile(dataFolder, resourcePath);
        }
    }

    private void ensureConfigFile(File dataFolder, String resourcePath) {
        if (dataFolder == null || resourcePath == null || resourcePath.isEmpty()) {
            return;
        }
        File target = new File(dataFolder, resourcePath);
        if (!target.exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    private void logStartupHeader() {
        String version = this.getDescription().getVersion();
        this.getLogger().info("========================================");
        this.getLogger().info("EzAuction v" + version + " starting up.");
    }
}

