/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezauction;

import com.skyblockexp.ezauction.AuctionListing;
import com.skyblockexp.ezauction.AuctionOperationResult;
import com.skyblockexp.ezauction.AuctionOrder;
import com.skyblockexp.ezauction.api.AuctionListingLimitResolver;
import com.skyblockexp.ezauction.config.AuctionConfiguration;
import com.skyblockexp.ezauction.live.LiveAuctionEntry;
import com.skyblockexp.ezauction.service.AuctionExpiryService;
import com.skyblockexp.ezauction.service.AuctionListingService;
import com.skyblockexp.ezauction.service.AuctionOrderService;
import com.skyblockexp.ezauction.service.AuctionQueryService;
import com.skyblockexp.ezauction.service.AuctionReturnService;
import com.skyblockexp.ezauction.util.AuctionValidationUtils;
import java.time.Duration;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class AuctionManager {
    private final AuctionListingService listingService;
    private final AuctionOrderService orderService;
    private final AuctionReturnService returnService;
    private final AuctionExpiryService expiryService;
    private final AuctionQueryService queryService;
    private final JavaPlugin plugin;
    private final AuctionConfiguration configuration;
    private final AuctionListingLimitResolver listingLimitResolver;

    public AuctionManager(JavaPlugin plugin, AuctionListingService listingService, AuctionOrderService orderService, AuctionReturnService returnService, AuctionExpiryService expiryService, AuctionQueryService queryService, AuctionConfiguration configuration, AuctionListingLimitResolver listingLimitResolver) {
        this.plugin = plugin;
        this.listingService = listingService;
        this.orderService = orderService;
        this.returnService = returnService;
        this.expiryService = expiryService;
        this.queryService = queryService;
        this.configuration = configuration;
        this.listingLimitResolver = listingLimitResolver;
    }

    public void enable() {
        this.expiryService.enable();
    }

    public List<AuctionListing> listActiveListings() {
        return this.queryService.listActiveListings();
    }

    public List<AuctionOrder> listActiveOrders() {
        return this.queryService.listActiveOrders();
    }

    public long countActiveListings(UUID sellerId) {
        return this.queryService.countActiveListings(sellerId);
    }

    public long countActiveOrders(UUID buyerId) {
        return this.queryService.countActiveOrders(buyerId);
    }

    public long countAllActiveListings() {
        return this.queryService.countAllActiveListings();
    }

    public long countAllActiveOrders() {
        return this.queryService.countAllActiveOrders();
    }

    public int countPendingReturnItems(UUID playerId) {
        return this.returnService.countPendingReturnItems(playerId);
    }

    public int resolveListingLimit(UUID sellerId) {
        return AuctionValidationUtils.resolveListingLimit(sellerId, this.configuration, this.listingLimitResolver);
    }

    public void handlePlayerLogin(Player player) {
        this.returnService.handlePlayerLogin(player);
    }

    public AuctionOperationResult claimReturnItems(Player player) {
        return this.returnService.claimReturnItems(player);
    }

    public void disable() {
        this.expiryService.disable();
    }

    public AuctionOperationResult createListing(Player seller, ItemStack item, double price, Duration duration) {
        return this.listingService.createListing(seller, item, price, duration);
    }

    public AuctionOperationResult purchaseListing(Player buyer, String listingId) {
        return this.listingService.purchaseListing(buyer, listingId);
    }

    public AuctionOperationResult cancelListing(UUID sellerId, String listingId) {
        return this.listingService.cancelListing(sellerId, listingId);
    }

    public AuctionOperationResult createOrder(Player buyer, ItemStack template, double offeredPrice, Duration duration, double reservedAmount) {
        return this.orderService.createOrder(buyer, template, offeredPrice, duration, reservedAmount);
    }

    public AuctionOperationResult fulfillOrder(Player seller, String orderId) {
        return this.orderService.fulfillOrder(seller, orderId);
    }

    public AuctionOperationResult cancelOrder(UUID buyerId, String orderId) {
        return this.orderService.cancelOrder(buyerId, orderId);
    }

    public void purgeExpiredEntries() {
        this.expiryService.purgeExpiredEntries();
    }

    public AuctionListing findHighestPricedListing() {
        return this.queryService.findHighestPricedListing();
    }

    public AuctionOrder findHighestPricedOrder() {
        return this.queryService.findHighestPricedOrder();
    }

    public AuctionListing findNextExpiringListing() {
        return this.queryService.findNextExpiringListing();
    }

    public boolean liveAuctionsEnabled() {
        return this.queryService.liveAuctionsEnabled();
    }

    public List<LiveAuctionEntry> listQueuedLiveAuctions() {
        return this.queryService.listQueuedLiveAuctions();
    }

    public long countActiveListings() {
        return this.queryService.countActiveListings();
    }

    public long countActiveOrders() {
        return this.queryService.countActiveOrders();
    }
}

