/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.util;

import java.time.Duration;

public final class DurationFormatter {
    private DurationFormatter() {
    }

    public static String formatDuration(long seconds) {
        if (seconds < 0L) {
            seconds = 0L;
        }
        Duration duration = Duration.ofSeconds(seconds);
        long days = duration.toDays();
        duration = duration.minusDays(days);
        long hours = duration.toHours();
        duration = duration.minusHours(hours);
        long minutes = duration.toMinutes();
        duration = duration.minusMinutes(minutes);
        long remainingSeconds = duration.getSeconds();
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L || builder.length() > 0) {
            builder.append(hours).append("h ");
        }
        if (minutes > 0L || builder.length() > 0) {
            builder.append(minutes).append("m ");
        }
        builder.append(remainingSeconds).append("s");
        return builder.toString().trim();
    }
}

