/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.manager;

import com.gyvex.ezafk.EzAfk;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;

public class MySQLManager {
    private static Connection connection;
    private static String host;
    private static String database;
    private static String username;
    private static String password;
    private static int port;
    private static boolean enabled;
    private static ExecutorService executor;
    private static final Logger LOGGER;

    public static void setup() {
        FileConfiguration mysqlConfig = EzAfk.getInstance().getMysqlConfig();
        enabled = mysqlConfig.getBoolean("enabled");
        if (!enabled) {
            MySQLManager.closeConnection();
            MySQLManager.shutdownExecutor();
            LOGGER.info("MySQL is disabled in configuration.");
            return;
        }
        host = mysqlConfig.getString("host");
        port = mysqlConfig.getInt("port");
        database = mysqlConfig.getString("database");
        username = mysqlConfig.getString("username");
        password = mysqlConfig.getString("password");
        if (host == null || host.isEmpty() || database == null || database.isEmpty() || username == null || username.isEmpty() || password == null) {
            LOGGER.severe("MySQL configuration is invalid. Please check host, database, username, and password fields.");
            enabled = false;
            return;
        }
        try {
            MySQLManager.ensureExecutor();
            MySQLManager.openConnection();
            LOGGER.info("MySQL connection established successfully.");
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Could not connect to MySQL server!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openConnection() throws SQLException {
        if (connection != null) {
            try {
                if (!connection.isClosed() && connection.isValid(2)) {
                    return;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "MySQL connection validation failed, attempting to reconnect.", e);
            }
        }
        Class<MySQLManager> clazz = MySQLManager.class;
        synchronized (MySQLManager.class) {
            if (connection == null || connection.isClosed() || !MySQLManager.isConnectionValid(connection)) {
                connection = DriverManager.getConnection("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&autoReconnect=true", username, password);
            }
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean isConnectionValid(Connection conn) {
        try {
            return conn != null && !conn.isClosed() && conn.isValid(2);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "MySQL connection validation threw an exception.", e);
            return false;
        }
    }

    private static void closeConnection() {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "Could not close MySQL connection!", e);
            }
        }
        connection = null;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isConnected() {
        if (!enabled) {
            MySQLManager.closeConnection();
            return false;
        }
        try {
            if (connection == null || connection.isClosed() || !MySQLManager.isConnectionValid(connection)) {
                MySQLManager.openConnection();
            }
            return MySQLManager.isConnectionValid(connection);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "MySQL connection is not available!", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAsync(Runnable task) {
        if (!enabled) {
            return;
        }
        Class<MySQLManager> clazz = MySQLManager.class;
        synchronized (MySQLManager.class) {
            MySQLManager.ensureExecutor();
            ExecutorService service = executor;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (service == null) {
                LOGGER.severe("MySQL executor is not available to schedule a task.");
                return;
            }
            service.execute(() -> {
                try {
                    task.run();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, "Unexpected error during asynchronous MySQL task", exception);
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureExecutor() {
        Class<MySQLManager> clazz = MySQLManager.class;
        synchronized (MySQLManager.class) {
            if (executor != null && !executor.isShutdown() && !executor.isTerminated()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicInteger counter = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "EzAfk-MySQL-" + this.counter.incrementAndGet());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            executor = Executors.newSingleThreadExecutor(threadFactory);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownExecutor() {
        Class<MySQLManager> clazz = MySQLManager.class;
        synchronized (MySQLManager.class) {
            if (executor != null) {
                executor.shutdownNow();
                executor = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void executeAddOrUpdateAfkPlayer(UUID playerId, long lastActive) {
        int attempts = 0;
        while (attempts < 2) {
            if (!MySQLManager.isConnected()) {
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                String selectQuery = "SELECT COUNT(*) FROM afk_players WHERE player_id = ?";
                try (PreparedStatement selectStatement = connection.prepareStatement(selectQuery);){
                    selectStatement.setString(1, playerId.toString());
                    try (ResultSet resultSet = selectStatement.executeQuery();){
                        if (resultSet.next() && resultSet.getInt(1) > 0) {
                            String updateQuery = "UPDATE afk_players SET last_active = ? WHERE player_id = ?";
                            try (PreparedStatement updateStatement = connection.prepareStatement(updateQuery);){
                                updateStatement.setLong(1, lastActive);
                                updateStatement.setString(2, playerId.toString());
                                updateStatement.executeUpdate();
                                break;
                            }
                        }
                        String insertQuery = "INSERT INTO afk_players (player_id, last_active) VALUES (?, ?)";
                        try (PreparedStatement insertStatement = connection.prepareStatement(insertQuery);){
                            insertStatement.setString(1, playerId.toString());
                            insertStatement.setLong(2, lastActive);
                            insertStatement.executeUpdate();
                            break;
                        }
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "MySQL operation failed, retrying if possible", e);
                MySQLManager.closeConnection();
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void executeRemoveAfkPlayer(UUID playerId) {
        int attempts = 0;
        while (attempts < 2) {
            if (!MySQLManager.isConnected()) {
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM afk_players WHERE player_id = ?");){
                statement.setString(1, playerId.toString());
                statement.executeUpdate();
                break;
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "MySQL remove operation failed, retrying if possible", e);
                MySQLManager.closeConnection();
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static void executeUpdateLastActive(UUID playerId, long lastActive) {
        int attempts = 0;
        while (attempts < 2) {
            if (!MySQLManager.isConnected()) {
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try (PreparedStatement statement = connection.prepareStatement("UPDATE afk_players SET last_active = ? WHERE player_id = ?");){
                statement.setLong(1, lastActive);
                statement.setString(2, playerId.toString());
                statement.executeUpdate();
                break;
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "MySQL update operation failed, retrying if possible", e);
                MySQLManager.closeConnection();
                ++attempts;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static void addAfkPlayerAsync(UUID playerId, long lastActive) {
        MySQLManager.runAsync(() -> MySQLManager.executeAddOrUpdateAfkPlayer(playerId, lastActive));
    }

    public static void removeAfkPlayerAsync(UUID playerId) {
        MySQLManager.runAsync(() -> MySQLManager.executeRemoveAfkPlayer(playerId));
    }

    public static void updateLastActiveAsync(UUID playerId, long lastActive) {
        MySQLManager.runAsync(() -> MySQLManager.executeUpdateLastActive(playerId, lastActive));
    }

    public static long getLastActive(UUID playerId) {
        long lastActive = 0L;
        if (!enabled || !MySQLManager.isConnected()) {
            return lastActive;
        }
        try {
            String query = "SELECT last_active FROM afk_players WHERE player_id = ?";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setString(1, playerId.toString());
                try (ResultSet resultSet = statement.executeQuery();){
                    if (resultSet.next()) {
                        lastActive = resultSet.getLong("last_active");
                    }
                }
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Could not retrieve last active time from MySQL!", e);
        }
        return lastActive;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean containsAfkPlayer(UUID playerId) {
        if (!enabled || !MySQLManager.isConnected()) {
            return false;
        }
        try {
            String query = "SELECT 1 FROM afk_players WHERE player_id = ?";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                boolean bl;
                block15: {
                    statement.setString(1, playerId.toString());
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        bl = resultSet.next();
                        if (resultSet == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return bl;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Could not check if AFK player exists in MySQL!", e);
            return false;
        }
    }

    public static void shutdown() {
        MySQLManager.closeConnection();
        MySQLManager.shutdownExecutor();
    }

    static {
        LOGGER = Logger.getLogger(MySQLManager.class.getName());
    }
}

