/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.manager;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.state.AfkState;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class MessageManager {
    private MessageManager() {
    }

    public static void sendMessage(CommandSender sender, String path, String fallback) {
        MessageManager.sendMessage(sender, path, fallback, null);
    }

    public static void sendMessage(CommandSender sender, String path, String fallback, Map<String, String> placeholders) {
        if (sender == null) {
            return;
        }
        String message = MessageManager.getMessage(path, fallback, placeholders);
        if (message != null && !message.isEmpty()) {
            sender.sendMessage(message);
        }
    }

    public static String getMessage(String path, String fallback) {
        return MessageManager.getMessage(path, fallback, null);
    }

    public static String getMessage(String path, String fallback, Map<String, String> placeholders) {
        EzAfk plugin = EzAfk.getInstance();
        String message = null;
        if (plugin != null && plugin.getMessages() != null) {
            message = plugin.getMessages().getString(path);
        }
        if (message == null) {
            message = fallback;
        }
        if (message == null) {
            return null;
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                String value = entry.getValue() != null ? entry.getValue() : "";
                message = message.replace("%" + entry.getKey() + "%", value);
            }
        }
        message = MessageManager.applyGlobalPlaceholders(message);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String applyGlobalPlaceholders(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        int afkCount = AfkState.getAfkPlayerCount();
        int activeCount = AfkState.getActivePlayerCount();
        return message.replace("%afk_count%", String.valueOf(afkCount)).replace("%afk_players%", String.valueOf(afkCount)).replace("%active_count%", String.valueOf(activeCount)).replace("%active_players%", String.valueOf(activeCount));
    }
}

