/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.integration.placeholder;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.state.AfkState;
import com.gyvex.ezafk.state.LastActiveState;
import com.gyvex.ezafk.util.DurationFormatter;
import java.util.Locale;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class EzAfkPlaceholderExpansion
extends PlaceholderExpansion {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("(-?\\d+)");
    private final boolean playtimeIntegrationEnabled;
    private final String playtimePlaceholder;

    public EzAfkPlaceholderExpansion() {
        FileConfiguration config = EzAfk.getInstance().getConfig();
        this.playtimeIntegrationEnabled = config.getBoolean("integration.playtime.enabled", false);
        this.playtimePlaceholder = config.getString("integration.playtime.placeholder", "%playtime_time_total_seconds%");
    }

    public String getIdentifier() {
        return "ezafk";
    }

    public String getAuthor() {
        return String.join((CharSequence)", ", EzAfk.getInstance().getDescription().getAuthors());
    }

    public String getVersion() {
        return EzAfk.getInstance().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, String identifier) {
        String params;
        if (identifier == null || identifier.isEmpty()) {
            return "";
        }
        switch (params = identifier.toLowerCase(Locale.ROOT)) {
            case "afk_count": 
            case "afk_players": {
                return String.valueOf(AfkState.getAfkPlayerCount());
            }
            case "active_count": 
            case "active_players": {
                return String.valueOf(AfkState.getActivePlayerCount());
            }
        }
        return this.handlePlayerSpecificPlaceholder(offlinePlayer, params);
    }

    private String handlePlayerSpecificPlaceholder(OfflinePlayer offlinePlayer, String params) {
        if (offlinePlayer == null) {
            return "";
        }
        UUID playerId = offlinePlayer.getUniqueId();
        return switch (params) {
            case "status" -> {
                if (AfkState.isAfk(playerId)) {
                    yield "AFK";
                }
                yield "ACTIVE";
            }
            case "status_colored" -> {
                if (AfkState.isAfk(playerId)) {
                    yield "&cAFK";
                }
                yield "&aACTIVE";
            }
            case "since" -> this.formatDurationSeconds(AfkState.getSecondsSinceAfk(playerId));
            case "last_active" -> this.formatDurationSeconds(LastActiveState.getSecondsSinceLastActive(playerId));
            case "total_seconds" -> this.formatDurationSeconds(AfkState.getTotalAfkSeconds(playerId));
            case "total" -> this.formatDurationPretty(AfkState.getTotalAfkSeconds(playerId));
            case "total_formatted" -> this.formatDurationPretty(AfkState.getTotalAfkSeconds(playerId));
            case "prefix" -> this.getConfigValue("afk.display-name.prefix");
            case "suffix" -> this.getConfigValue("afk.display-name.suffix");
            case "playtime_active_seconds" -> this.formatOptionalSeconds(this.getActivePlaytimeSeconds(offlinePlayer, playerId), false);
            case "playtime_active" -> this.formatOptionalSeconds(this.getActivePlaytimeSeconds(offlinePlayer, playerId), true);
            case "playtime_active_formatted" -> this.formatOptionalSeconds(this.getActivePlaytimeSeconds(offlinePlayer, playerId), true);
            default -> "";
        };
    }

    private String getConfigValue(String path) {
        String value = EzAfk.getInstance().getConfig().getString(path, "");
        return value == null ? "" : value;
    }

    private String formatDurationSeconds(long seconds) {
        if (seconds < 0L) {
            return "";
        }
        return String.valueOf(seconds);
    }

    private String formatDurationPretty(long seconds) {
        if (seconds < 0L) {
            seconds = 0L;
        }
        return DurationFormatter.formatDuration(seconds);
    }

    private OptionalLong getActivePlaytimeSeconds(OfflinePlayer offlinePlayer, UUID playerId) {
        OptionalLong playtimeSeconds = this.resolvePlaytimeSeconds(offlinePlayer);
        if (playtimeSeconds.isEmpty()) {
            return OptionalLong.empty();
        }
        long activeSeconds = playtimeSeconds.getAsLong() - AfkState.getTotalAfkSeconds(playerId);
        if (activeSeconds < 0L) {
            activeSeconds = 0L;
        }
        return OptionalLong.of(activeSeconds);
    }

    private OptionalLong resolvePlaytimeSeconds(OfflinePlayer offlinePlayer) {
        if (!this.isPlaytimeIntegrationActive() || offlinePlayer == null) {
            return OptionalLong.empty();
        }
        if (this.playtimePlaceholder == null || this.playtimePlaceholder.isBlank()) {
            return OptionalLong.empty();
        }
        String resolved = PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)this.playtimePlaceholder);
        if (resolved == null) {
            return OptionalLong.empty();
        }
        if ((resolved = resolved.trim()).isEmpty()) {
            return OptionalLong.empty();
        }
        Long parsed = this.parseLongValue(resolved);
        if (parsed == null) {
            return OptionalLong.empty();
        }
        long seconds = parsed;
        if (seconds < 0L) {
            seconds = 0L;
        }
        return OptionalLong.of(seconds);
    }

    private boolean isPlaytimeIntegrationActive() {
        if (!this.playtimeIntegrationEnabled) {
            return false;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Playtime");
        return plugin != null && plugin.isEnabled();
    }

    private Long parseLongValue(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            Matcher matcher = INTEGER_PATTERN.matcher(value);
            if (matcher.find()) {
                try {
                    return Long.parseLong(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private String formatOptionalSeconds(OptionalLong seconds, boolean pretty) {
        if (seconds.isEmpty()) {
            return "";
        }
        long value = seconds.getAsLong();
        return pretty ? this.formatDurationPretty(value) : this.formatDurationSeconds(value);
    }
}

