/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.integration;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.integration.Integration;
import com.gyvex.ezafk.integration.PlayerListNameAdapter;
import com.gyvex.ezafk.state.AfkState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TabIntegration
extends Integration {
    private static final int PLAYER_LIST_NAME_LIMIT = 80;
    private static final String TAB_AFK_PLACEHOLDER = "%afk%";
    private static final int TAB_AFK_PLACEHOLDER_REFRESH_INTERVAL = 200;
    private boolean tabPrefixEnabled;
    private String prefixTemplate;
    private String suffixTemplate;
    private String formatTemplate;
    private TabIntegrationMode integrationMode = TabIntegrationMode.AUTO;
    private final BukkitTabNameAdapter bukkitAdapter = new BukkitTabNameAdapter();
    private PlayerListNameAdapter tabApiAdapter;
    private boolean tabApiUnavailableLogged;
    private boolean tabPlaceholderRegistered;
    private boolean tabPlaceholderUnavailableLogged;

    public TabIntegration() {
        this.reloadFromConfig();
    }

    public void reloadFromConfig() {
        this.tabPrefixEnabled = EzAfk.getInstance().getConfig().getBoolean("afk.tab-prefix.enabled");
        this.prefixTemplate = EzAfk.getInstance().getConfig().getString("afk.tab-prefix.prefix", "");
        this.suffixTemplate = EzAfk.getInstance().getConfig().getString("afk.tab-prefix.suffix", "");
        this.formatTemplate = EzAfk.getInstance().getConfig().getString("afk.tab-prefix.format", "%prefix%%player%%suffix%");
        this.integrationMode = this.resolveIntegrationMode();
        this.tabApiUnavailableLogged = false;
        this.tabPlaceholderUnavailableLogged = false;
    }

    public void update() {
        this.refreshTabApiAdapter();
        if (this.shouldUseTabPlugin()) {
            this.ensureTabPlaceholderRegistration();
        } else {
            this.unregisterTabPlaceholder();
        }
        if (!this.isIntegrationEnabled() || !this.tabPrefixEnabled) {
            if (this.tabApiAdapter != null) {
                this.tabApiAdapter.restoreAll();
            }
            this.bukkitAdapter.restoreAll();
            this.unregisterTabPlaceholder();
            return;
        }
        if (this.tabApiAdapter != null) {
            this.tabApiAdapter.removeInvalidEntries();
        }
        this.bukkitAdapter.removeInvalidEntries();
        for (Player player : Bukkit.getOnlinePlayers()) {
            UUID uuid = player.getUniqueId();
            if (AfkState.isAfk(uuid)) {
                if (this.applyUsingTabApi(player)) continue;
                this.applyUsingBukkit(player);
                continue;
            }
            if (this.tabApiAdapter != null) {
                this.tabApiAdapter.restore(uuid);
            }
            this.bukkitAdapter.restore(uuid);
        }
    }

    private boolean applyUsingTabApi(Player player) {
        if (this.tabApiAdapter == null) {
            return false;
        }
        String baseName = this.tabApiAdapter.getBaseName(player);
        if (baseName == null) {
            return false;
        }
        UUID uuid = player.getUniqueId();
        this.bukkitAdapter.restore(uuid);
        String targetName = this.buildAfkListName(baseName);
        return this.tabApiAdapter.apply(player, targetName);
    }

    private void applyUsingBukkit(Player player) {
        String baseName = this.bukkitAdapter.getBaseName(player);
        String targetName = this.buildAfkListName(baseName);
        this.bukkitAdapter.apply(player, targetName);
    }

    private String buildAfkListName(String baseName) {
        String format = this.formatTemplate;
        if (format == null || format.isEmpty()) {
            format = "%prefix%%player%%suffix%";
        }
        String prefix = this.prefixTemplate == null ? "" : this.prefixTemplate;
        String suffix = this.suffixTemplate == null ? "" : this.suffixTemplate;
        String combined = format.replace("%prefix%", prefix).replace("%player%", baseName).replace("%suffix%", suffix);
        if ((combined = ChatColor.translateAlternateColorCodes((char)'&', (String)combined)).length() <= 80) {
            return combined;
        }
        String trimmed = combined.substring(0, 80);
        if (trimmed.endsWith("\u00a7")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    private void refreshTabApiAdapter() {
        boolean tabPluginEnabled;
        if (!this.shouldUseTabPlugin()) {
            if (this.tabApiAdapter != null) {
                this.tabApiAdapter.restoreAll();
                this.tabApiAdapter = null;
            }
            return;
        }
        Plugin tabPlugin = Bukkit.getPluginManager().getPlugin("TAB");
        boolean bl = tabPluginEnabled = tabPlugin != null && tabPlugin.isEnabled();
        if (!tabPluginEnabled) {
            if (this.tabApiAdapter != null) {
                this.tabApiAdapter.restoreAll();
                this.tabApiAdapter = null;
            }
            if (this.integrationMode == TabIntegrationMode.TAB && !this.tabApiUnavailableLogged) {
                EzAfk.getInstance().getLogger().log(Level.WARNING, "TAB support requested but the plugin is not installed or disabled. Falling back to Bukkit player list.");
                this.tabApiUnavailableLogged = true;
            }
            return;
        }
        if (this.tabApiAdapter == null) {
            PlayerListNameAdapter adapter = this.createTabApiAdapter();
            if (adapter != null) {
                this.tabApiAdapter = adapter;
                this.tabApiUnavailableLogged = false;
            } else if (!this.tabApiUnavailableLogged) {
                EzAfk.getInstance().getLogger().log(Level.WARNING, "TAB detected but API is unavailable. Falling back to Bukkit player list.");
                this.tabApiUnavailableLogged = true;
            }
        }
    }

    private PlayerListNameAdapter createTabApiAdapter() {
        try {
            Class<?> adapterClass = Class.forName("com.gyvex.ezafk.integration.TabApiPlayerListNameAdapter");
            if (!PlayerListNameAdapter.class.isAssignableFrom(adapterClass)) {
                return null;
            }
            return (PlayerListNameAdapter)adapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            if (!this.tabApiUnavailableLogged) {
                EzAfk.getInstance().getLogger().log(Level.FINE, "Failed to initialize TAB API adapter", ex);
            }
            return null;
        }
        catch (LinkageError ex) {
            if (!this.tabApiUnavailableLogged) {
                EzAfk.getInstance().getLogger().log(Level.FINE, "Failed to initialize TAB API adapter", ex);
            }
            return null;
        }
    }

    @Override
    public void load() {
        this.refreshTabApiAdapter();
        this.update();
        this.isSetup = true;
    }

    @Override
    public void unload() {
        if (this.tabApiAdapter != null) {
            this.tabApiAdapter.restoreAll();
        }
        this.bukkitAdapter.restoreAll();
        this.unregisterTabPlaceholder();
    }

    private void ensureTabPlaceholderRegistration() {
        if (this.tabPlaceholderRegistered) {
            return;
        }
        if (!this.shouldUseTabPlugin()) {
            return;
        }
        try {
            TabAPI tabAPI = TabAPI.getInstance();
            if (tabAPI == null) {
                return;
            }
            PlaceholderManager placeholderManager = tabAPI.getPlaceholderManager();
            if (placeholderManager == null) {
                return;
            }
            placeholderManager.registerPlayerPlaceholder(TAB_AFK_PLACEHOLDER, 200, tabPlayer -> this.buildPlaceholderValue((TabPlayer)tabPlayer));
            this.tabPlaceholderRegistered = true;
            this.tabPlaceholderUnavailableLogged = false;
        }
        catch (LinkageError ex) {
            this.handlePlaceholderRegistrationFailure(ex);
        }
        catch (Exception ex) {
            this.handlePlaceholderRegistrationFailure(ex);
        }
    }

    private String buildPlaceholderValue(TabPlayer tabPlayer) {
        String prefix;
        if (tabPlayer == null || !this.tabPrefixEnabled) {
            return "";
        }
        UUID uuid = tabPlayer.getUniqueId();
        if (uuid == null || !AfkState.isAfk(uuid)) {
            return "";
        }
        String string = prefix = this.prefixTemplate == null ? "" : this.prefixTemplate;
        if (prefix.isEmpty()) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    private void unregisterTabPlaceholder() {
        if (!this.tabPlaceholderRegistered) {
            return;
        }
        try {
            PlaceholderManager placeholderManager;
            TabAPI tabAPI = TabAPI.getInstance();
            if (tabAPI != null && (placeholderManager = tabAPI.getPlaceholderManager()) != null) {
                placeholderManager.unregisterPlaceholder(TAB_AFK_PLACEHOLDER);
            }
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tabPlaceholderRegistered = false;
    }

    private void handlePlaceholderRegistrationFailure(Throwable throwable) {
        if (!this.tabPlaceholderUnavailableLogged) {
            EzAfk.getInstance().getLogger().log(Level.FINE, "Failed to register TAB AFK placeholder", throwable);
            this.tabPlaceholderUnavailableLogged = true;
        }
    }

    private boolean shouldUseTabPlugin() {
        if (!this.isIntegrationEnabled()) {
            return false;
        }
        return this.integrationMode != TabIntegrationMode.CUSTOM;
    }

    private boolean isIntegrationEnabled() {
        return EzAfk.getInstance().config.getBoolean("integration.tab");
    }

    private TabIntegrationMode resolveIntegrationMode() {
        String rawValue = EzAfk.getInstance().getConfig().getString("afk.tab-prefix.mode", "auto");
        TabIntegrationMode resolved = TabIntegrationMode.fromConfig(rawValue);
        if (resolved == null) {
            EzAfk.getInstance().getLogger().log(Level.WARNING, "Unknown afk.tab-prefix.mode value '{0}'. Falling back to AUTO.", rawValue);
            return TabIntegrationMode.AUTO;
        }
        return resolved;
    }

    private static enum TabIntegrationMode {
        AUTO,
        TAB,
        CUSTOM;


        private static TabIntegrationMode fromConfig(String value) {
            if (value == null) {
                return AUTO;
            }
            try {
                return TabIntegrationMode.valueOf(value.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }

    private static class BukkitTabNameAdapter
    implements PlayerListNameAdapter {
        private final Map<UUID, String> originalPlayerListNames = new HashMap<UUID, String>();

        private BukkitTabNameAdapter() {
        }

        @Override
        public void removeInvalidEntries() {
            this.originalPlayerListNames.keySet().removeIf(uuid -> Bukkit.getPlayer((UUID)uuid) == null);
        }

        @Override
        public String getBaseName(Player player) {
            UUID uuid = player.getUniqueId();
            return this.originalPlayerListNames.computeIfAbsent(uuid, id -> {
                String currentListName = player.getPlayerListName();
                if (currentListName == null || currentListName.isEmpty()) {
                    currentListName = player.getName();
                }
                return currentListName;
            });
        }

        @Override
        public boolean apply(Player player, String targetName) {
            if (!targetName.equals(player.getPlayerListName())) {
                player.setPlayerListName(targetName);
            }
            return true;
        }

        @Override
        public boolean restore(UUID uuid) {
            String original = this.originalPlayerListNames.remove(uuid);
            if (original == null) {
                return false;
            }
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                player.setPlayerListName(original);
            }
            return true;
        }

        @Override
        public void restoreAll() {
            HashSet<UUID> trackedPlayers = new HashSet<UUID>(this.originalPlayerListNames.keySet());
            for (UUID uuid : trackedPlayers) {
                this.restore(uuid);
            }
            this.originalPlayerListNames.clear();
        }
    }
}

