/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.integration;

import com.gyvex.ezafk.integration.PlayerListNameAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

class TabApiPlayerListNameAdapter
implements PlayerListNameAdapter {
    private final TabAPI tabAPI;
    private final Set<UUID> managedPlayers = new HashSet<UUID>();
    private final TargetMethods targetMethods;
    private final Logger logger = Bukkit.getLogger();

    TabApiPlayerListNameAdapter() {
        TabAPI api = TabAPI.getInstance();
        if (api == null) {
            throw new IllegalStateException("TAB API returned null instance");
        }
        this.tabAPI = api;
        this.targetMethods = this.resolveTargetMethods();
    }

    @Override
    public void removeInvalidEntries() {
        Iterator<UUID> iterator = this.managedPlayers.iterator();
        while (iterator.hasNext()) {
            UUID uuid = iterator.next();
            Player player = Bukkit.getPlayer((UUID)uuid);
            TabPlayer tabPlayer = this.tabAPI.getPlayer(uuid);
            if (player != null && tabPlayer != null) continue;
            iterator.remove();
        }
    }

    @Override
    public String getBaseName(Player player) {
        TabPlayer tabPlayer = this.tabAPI.getPlayer(player.getUniqueId());
        if (tabPlayer == null) {
            return null;
        }
        String currentListName = player.getPlayerListName();
        if (currentListName == null || currentListName.isEmpty()) {
            currentListName = player.getName();
        }
        return currentListName;
    }

    @Override
    public boolean apply(Player player, String targetName) {
        TabPlayer tabPlayer = this.tabAPI.getPlayer(player.getUniqueId());
        if (tabPlayer == null || this.targetMethods.apply == null) {
            return false;
        }
        try {
            this.invokeApplyMethod(tabPlayer, targetName);
            this.managedPlayers.add(player.getUniqueId());
            return true;
        }
        catch (IllegalArgumentException | IllegalStateException | ReflectiveOperationException ex) {
            this.logger.log(Level.FINE, "Failed to set temporary TAB player list name", ex);
            return false;
        }
    }

    @Override
    public boolean restore(UUID uuid) {
        if (!this.managedPlayers.remove(uuid)) {
            return false;
        }
        TabPlayer tabPlayer = this.tabAPI.getPlayer(uuid);
        if (tabPlayer != null && this.targetMethods.reset != null) {
            try {
                Object invocationTarget = this.resolveInvocationTarget(tabPlayer);
                if (invocationTarget != null) {
                    this.targetMethods.reset.invoke(invocationTarget, new Object[0]);
                }
            }
            catch (IllegalArgumentException | IllegalStateException | ReflectiveOperationException ex) {
                this.logger.log(Level.FINE, "Failed to reset temporary TAB player list name", ex);
            }
        }
        return true;
    }

    @Override
    public void restoreAll() {
        HashSet<UUID> trackedPlayers = new HashSet<UUID>(this.managedPlayers);
        for (UUID uuid : trackedPlayers) {
            this.restore(uuid);
        }
        this.managedPlayers.clear();
    }

    private TargetMethods resolveTargetMethods() {
        Method applyMethod = this.resolveApplyMethod(TabPlayer.class);
        Method resetMethod = this.resolveResetMethod(TabPlayer.class);
        if (applyMethod != null) {
            return new TargetMethods(null, applyMethod, resetMethod, this.determineApplyValueType(applyMethod));
        }
        Method accessor = this.resolveTabListAccessor();
        if (accessor != null) {
            Class<?> targetClass = accessor.getReturnType();
            Method targetApply = this.resolveApplyMethod(targetClass);
            Method targetReset = this.resolveResetMethod(targetClass);
            if (targetApply != null) {
                return new TargetMethods(accessor, targetApply, targetReset, this.determineApplyValueType(targetApply));
            }
        }
        return new TargetMethods(null, null, null, null);
    }

    private Method resolveApplyMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?> parameterType;
            Class<?>[] parameterTypes;
            if (!this.isPotentialApplyMethod(method) || (parameterTypes = method.getParameterTypes()).length != 1 || (parameterType = parameterTypes[0]) != String.class && !this.isKyoriComponent(parameterType) && !this.isBungeeComponentArray(parameterType)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private boolean isPotentialApplyMethod(Method method) {
        String name = method.getName().toLowerCase(Locale.ROOT);
        return name.contains("name") && (name.contains("set") || name.contains("apply"));
    }

    private Method resolveResetMethod(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            String name = method.getName().toLowerCase(Locale.ROOT);
            if (!name.contains("reset") || !name.contains("name") || method.getParameterCount() != 0) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private Method resolveTabListAccessor() {
        Class<TabPlayer> clazz = TabPlayer.class;
        for (Method method : clazz.getMethods()) {
            Class<?> returnType;
            if (method.getParameterCount() != 0 || (returnType = method.getReturnType()) == Void.TYPE) continue;
            String name = method.getName().toLowerCase(Locale.ROOT);
            if (name.contains("tab") && name.contains("list")) {
                method.setAccessible(true);
                return method;
            }
            if (!returnType.getSimpleName().toLowerCase(Locale.ROOT).contains("tablist")) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    private ApplyValueType determineApplyValueType(Method method) {
        if (method == null) {
            return null;
        }
        Class<?> parameterType = method.getParameterTypes()[0];
        if (parameterType == String.class) {
            return ApplyValueType.STRING;
        }
        if (this.isKyoriComponent(parameterType)) {
            return ApplyValueType.KYORI_COMPONENT;
        }
        if (this.isBungeeComponentArray(parameterType)) {
            return ApplyValueType.BUNGEE_COMPONENT_ARRAY;
        }
        return null;
    }

    private boolean isKyoriComponent(Class<?> type) {
        return KyoriComponentBridge.isComponentType(type);
    }

    private boolean isBungeeComponentArray(Class<?> type) {
        return type.isArray() && BaseComponent.class.isAssignableFrom(type.getComponentType());
    }

    private void invokeApplyMethod(TabPlayer tabPlayer, String targetName) throws InvocationTargetException, IllegalAccessException {
        if (this.targetMethods.apply == null || this.targetMethods.valueType == null) {
            throw new IllegalStateException("TAB temporary name method unavailable");
        }
        Object invocationTarget = this.resolveInvocationTarget(tabPlayer);
        if (invocationTarget == null) {
            throw new IllegalStateException("TAB temporary name target unavailable");
        }
        this.targetMethods.apply.invoke(invocationTarget, new Object[]{switch (this.targetMethods.valueType.ordinal()) {
            case 0 -> targetName;
            case 1 -> KyoriComponentBridge.deserialize(targetName);
            case 2 -> TextComponent.fromLegacyText((String)targetName);
            default -> throw new IllegalStateException("Unsupported TAB temporary name argument type");
        }});
    }

    private Object resolveInvocationTarget(TabPlayer tabPlayer) throws InvocationTargetException, IllegalAccessException {
        if (this.targetMethods.accessor == null) {
            return tabPlayer;
        }
        Object tabList = this.targetMethods.accessor.invoke((Object)tabPlayer, new Object[0]);
        if (tabList == null) {
            throw new IllegalStateException("TAB tab list accessor returned null");
        }
        return tabList;
    }

    private static final class TargetMethods {
        private final Method accessor;
        private final Method apply;
        private final Method reset;
        private final ApplyValueType valueType;

        private TargetMethods(Method accessor, Method apply, Method reset, ApplyValueType valueType) {
            this.accessor = accessor;
            this.apply = apply;
            this.reset = reset;
            this.valueType = valueType;
        }
    }

    private static enum ApplyValueType {
        STRING,
        KYORI_COMPONENT,
        BUNGEE_COMPONENT_ARRAY;

    }

    private static final class KyoriComponentBridge {
        private static final Class<?> COMPONENT_CLASS = KyoriComponentBridge.loadClass("net.kyori.adventure.text.Component");
        private static final Class<?> COMPONENT_LIKE_CLASS = KyoriComponentBridge.loadClass("net.kyori.adventure.text.ComponentLike");
        private static final LegacySerializer LEGACY_SERIALIZER = KyoriComponentBridge.resolveLegacySerializer();

        private KyoriComponentBridge() {
        }

        private static Class<?> loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }

        private static boolean isComponentType(Class<?> type) {
            if (type == null) {
                return false;
            }
            if (COMPONENT_CLASS != null && COMPONENT_CLASS.isAssignableFrom(type)) {
                return true;
            }
            if (COMPONENT_LIKE_CLASS != null && COMPONENT_LIKE_CLASS.isAssignableFrom(type)) {
                return true;
            }
            return COMPONENT_CLASS != null && type.isAssignableFrom(COMPONENT_CLASS);
        }

        private static Object deserialize(String value) {
            if (LEGACY_SERIALIZER == null) {
                throw new IllegalStateException("Kyori legacy serializer unavailable");
            }
            return LEGACY_SERIALIZER.deserialize(value);
        }

        private static LegacySerializer resolveLegacySerializer() {
            Class<?> serializerClass = KyoriComponentBridge.loadClass("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            if (serializerClass == null) {
                return null;
            }
            try {
                Object instance = serializerClass.getMethod("legacySection", new Class[0]).invoke(null, new Object[0]);
                Method deserialize = serializerClass.getMethod("deserialize", String.class);
                return new LegacySerializer(instance, deserialize);
            }
            catch (ReflectiveOperationException | RuntimeException ex) {
                return null;
            }
        }

        private record LegacySerializer(Object instance, Method deserializeMethod) {
            private Object deserialize(String value) {
                try {
                    return this.deserializeMethod.invoke(this.instance, value);
                }
                catch (ReflectiveOperationException | RuntimeException ex) {
                    throw new IllegalStateException("Failed to deserialize legacy component", ex);
                }
            }
        }
    }
}

