/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.integration;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.integration.EconomyIntegration;
import com.gyvex.ezafk.integration.Integration;
import com.gyvex.ezafk.manager.IntegrationManager;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyServiceListener
implements Listener {
    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        if (!this.isEconomyService(event.getProvider())) {
            return;
        }
        EconomyIntegration economyIntegration = this.getEconomyIntegration();
        if (economyIntegration == null) {
            return;
        }
        economyIntegration.load();
        if (economyIntegration.isSetup) {
            this.log("Economy provider registered; refreshed economy integration.");
        }
    }

    @EventHandler
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        if (!this.isEconomyService(event.getProvider())) {
            return;
        }
        EconomyIntegration economyIntegration = this.getEconomyIntegration();
        if (economyIntegration == null) {
            return;
        }
        economyIntegration.unload();
        this.log("Economy provider unregistered; unloaded economy integration.");
    }

    private boolean isEconomyService(RegisteredServiceProvider<?> provider) {
        return provider != null && Economy.class.equals((Object)provider.getService());
    }

    private EconomyIntegration getEconomyIntegration() {
        Integration integration = IntegrationManager.getIntegration("economy");
        if (integration instanceof EconomyIntegration) {
            return (EconomyIntegration)integration;
        }
        return null;
    }

    private void log(String message) {
        EzAfk plugin = EzAfk.getInstance();
        if (plugin == null) {
            return;
        }
        Logger logger = plugin.getLogger();
        if (logger != null) {
            logger.info(message);
        }
    }
}

