/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.gui;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.compatibility.CompatibilityUtil;
import com.gyvex.ezafk.gui.AfkPlayerActionsGUI;
import com.gyvex.ezafk.manager.MessageManager;
import com.gyvex.ezafk.state.AfkState;
import com.gyvex.ezafk.state.AfkStatusDetails;
import com.gyvex.ezafk.state.LastActiveState;
import com.gyvex.ezafk.util.DurationFormatter;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class AfkPlayerOverviewGUI
implements Listener {
    private static final DateTimeFormatter LAST_SEEN_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());
    private static final int INVENTORY_SIZE = 54;
    private static final int PAGE_SIZE = 45;
    private static final int PREVIOUS_PAGE_SLOT = 45;
    private static final int NEXT_PAGE_SLOT = 53;
    private static final int LIST_TOGGLE_SLOT = 49;
    private static final String PLAYER_UUID_KEY = "afk_overview_uuid";
    private static final String LIST_TOGGLE_KEY = "afk_overview_list_toggle";

    public void openGUI(Player player, int page) {
        this.openGUI(player, page, PlayerListType.AFK);
    }

    public void openGUI(Player player, int page, PlayerListType listType) {
        List<OfflinePlayer> trackedPlayers = this.getPlayers(listType);
        int totalPages = Math.max(1, (int)Math.ceil((double)trackedPlayers.size() / 45.0));
        if (page < 1) {
            page = 1;
        } else if (page > totalPages) {
            page = totalPages;
        }
        Inventory inventory = Bukkit.createInventory(null, (int)54, (String)(listType.getTitle() + " - Page " + page));
        if (!trackedPlayers.isEmpty()) {
            int startIndex = (page - 1) * 45;
            int endIndex = Math.min(startIndex + 45, trackedPlayers.size());
            for (int i = startIndex; i < endIndex; ++i) {
                OfflinePlayer offlinePlayer = trackedPlayers.get(i);
                ItemStack playerHead = this.createPlayerHead(offlinePlayer);
                inventory.addItem(new ItemStack[]{playerHead});
            }
        }
        ItemStack prevPageItem = this.createButtonItem(String.valueOf(ChatColor.GREEN) + "Previous Page", Material.ARROW);
        ItemStack nextPageItem = this.createButtonItem(String.valueOf(ChatColor.GREEN) + "Next Page", Material.ARROW);
        if (page > 1) {
            inventory.setItem(45, prevPageItem);
        }
        if (page < totalPages) {
            inventory.setItem(53, nextPageItem);
        }
        inventory.setItem(49, this.createToggleItem(listType));
        player.openInventory(inventory);
    }

    private List<OfflinePlayer> getPlayers(PlayerListType listType) {
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        if (listType == PlayerListType.AFK) {
            ArrayList<UUID> afkPlayers = new ArrayList<UUID>(AfkState.afkPlayers);
            for (UUID playerId : afkPlayers) {
                players.add(Bukkit.getOfflinePlayer((UUID)playerId));
            }
        } else {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (AfkState.isAfk(onlinePlayer.getUniqueId())) continue;
                players.add((OfflinePlayer)onlinePlayer);
            }
        }
        return players;
    }

    private ItemStack createPlayerHead(OfflinePlayer offlinePlayer) {
        ItemStack head = CompatibilityUtil.createPlayerHead();
        ItemMeta meta = head.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            return head;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        CompatibilityUtil.setSkullOwner(skullMeta, offlinePlayer);
        String displayName = offlinePlayer.getName();
        if (displayName == null || displayName.isEmpty()) {
            displayName = offlinePlayer.getUniqueId().toString();
        }
        skullMeta.setDisplayName(String.valueOf(ChatColor.YELLOW) + displayName);
        List<String> lore = this.buildPlayerLore(offlinePlayer);
        if (!lore.isEmpty()) {
            skullMeta.setLore(lore);
        }
        CompatibilityUtil.setItemMetadata((ItemMeta)skullMeta, PLAYER_UUID_KEY, offlinePlayer.getUniqueId().toString());
        head.setItemMeta((ItemMeta)skullMeta);
        return head;
    }

    private List<String> buildPlayerLore(OfflinePlayer offlinePlayer) {
        ArrayList<String> lore = new ArrayList<String>();
        UUID playerId = offlinePlayer.getUniqueId();
        if (offlinePlayer.isOnline()) {
            lore.add(String.valueOf(ChatColor.GRAY) + "Status: " + String.valueOf(ChatColor.GREEN) + "Online");
            Player onlinePlayer = offlinePlayer.getPlayer();
            if (onlinePlayer != null) {
                lore.add(String.valueOf(ChatColor.GRAY) + "World: " + String.valueOf(ChatColor.AQUA) + onlinePlayer.getWorld().getName());
            }
            long lastActive = LastActiveState.getSecondsSinceLastActive(playerId);
            lore.add(String.valueOf(ChatColor.GRAY) + "Last Activity: " + String.valueOf(ChatColor.AQUA) + DurationFormatter.formatDuration(lastActive));
        } else {
            lore.add(String.valueOf(ChatColor.GRAY) + "Status: " + String.valueOf(ChatColor.RED) + "Offline");
            long lastPlayed = offlinePlayer.getLastPlayed();
            if (lastPlayed > 0L) {
                Duration since = Duration.between(Instant.ofEpochMilli(lastPlayed), Instant.now());
                if (since.isNegative()) {
                    since = Duration.ZERO;
                }
                lore.add(String.valueOf(ChatColor.GRAY) + "Last Active: " + String.valueOf(ChatColor.AQUA) + DurationFormatter.formatDuration(since.getSeconds()) + String.valueOf(ChatColor.GRAY) + " ago");
                lore.add(String.valueOf(ChatColor.GRAY) + "Last Seen: " + String.valueOf(ChatColor.AQUA) + LAST_SEEN_FORMATTER.format(Instant.ofEpochMilli(lastPlayed)));
            }
        }
        if (AfkState.isAfk(playerId)) {
            AfkStatusDetails details;
            long afkSeconds = AfkState.getSecondsSinceAfk(playerId);
            if (afkSeconds >= 0L) {
                lore.add(String.valueOf(ChatColor.GRAY) + "AFK for: " + String.valueOf(ChatColor.AQUA) + DurationFormatter.formatDuration(afkSeconds));
            }
            if ((details = AfkState.getAfkStatusDetails(playerId)) != null) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Reason: " + String.valueOf(ChatColor.YELLOW) + details.getReasonDisplayName());
                if (details.hasDetail()) {
                    lore.add(String.valueOf(ChatColor.DARK_GRAY) + details.detail());
                }
            }
        }
        return lore;
    }

    private ItemStack createButtonItem(String displayName, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createToggleItem(PlayerListType currentType) {
        ItemStack item = new ItemStack(Material.NETHER_STAR);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(currentType.getToggleDisplayName());
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Switch to " + String.valueOf(ChatColor.AQUA) + currentType.getOpposite().getFriendlyName())));
            meta.setLore(lore);
            CompatibilityUtil.setItemMetadata(meta, LIST_TOGGLE_KEY, currentType.getOpposite().name());
            item.setItemMeta(meta);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String targetListTypeName;
        String title = CompatibilityUtil.getInventoryTitle((InventoryEvent)event);
        PlayerListType listType = PlayerListType.fromTitle(title);
        if (listType == null) {
            return;
        }
        if (event.getClickedInventory() == null || event.getView().getTopInventory() != event.getClickedInventory()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        Player player = (Player)event.getWhoClicked();
        int currentPage = 1;
        int lastSpace = title.lastIndexOf(" ");
        if (lastSpace >= 0) {
            try {
                currentPage = Integer.parseInt(title.substring(lastSpace + 1));
            }
            catch (NumberFormatException ignored) {
                currentPage = 1;
            }
        }
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta itemMeta = clickedItem.getItemMeta();
        if (itemMeta != null && (targetListTypeName = CompatibilityUtil.getItemMetadata(itemMeta, LIST_TOGGLE_KEY)) != null) {
            try {
                PlayerListType targetType = PlayerListType.valueOf(targetListTypeName);
                if (targetType == PlayerListType.ACTIVE && !player.hasPermission("ezafk.gui.view-active") && !player.isOp()) {
                    MessageManager.sendMessage((CommandSender)player, "gui.overview.active.no-permission", "&cYou don't have permission to view active players.");
                    return;
                }
                this.openGUI(player, 1, targetType);
            }
            catch (IllegalArgumentException exception) {
                EzAfk.getInstance().getLogger().warning("Invalid overview list type metadata: " + targetListTypeName);
            }
            return;
        }
        if (CompatibilityUtil.isPlayerHead(clickedItem)) {
            UUID playerId;
            if (!player.hasPermission("ezafk.gui.actions") && !player.isOp()) {
                MessageManager.sendMessage((CommandSender)player, "gui.actions.no-permission", "&cYou don't have permission to use player actions.");
                return;
            }
            if (itemMeta == null) {
                return;
            }
            String storedUuid = CompatibilityUtil.getItemMetadata(itemMeta, PLAYER_UUID_KEY);
            if (storedUuid == null) {
                EzAfk.getInstance().getLogger().warning("Player head missing AFK UUID metadata");
                return;
            }
            try {
                playerId = UUID.fromString(storedUuid);
            }
            catch (IllegalArgumentException exception) {
                EzAfk.getInstance().getLogger().warning("Invalid AFK UUID metadata: " + storedUuid);
                return;
            }
            AfkPlayerActionsGUI actionsGUI = AfkPlayerActionsGUI.getInstance();
            if (actionsGUI == null) {
                EzAfk.getInstance().getLogger().warning("Player actions GUI is not initialized. Unable to open player actions view.");
                return;
            }
            actionsGUI.openGUI(player, Bukkit.getPlayer((UUID)playerId), currentPage, listType);
        } else if (clickedItem.getType() == Material.ARROW) {
            if (itemMeta == null) {
                return;
            }
            String displayName = itemMeta.getDisplayName();
            if ((String.valueOf(ChatColor.GREEN) + "Previous Page").equals(displayName)) {
                this.openGUI(player, currentPage - 1, listType);
            } else if ((String.valueOf(ChatColor.GREEN) + "Next Page").equals(displayName)) {
                this.openGUI(player, currentPage + 1, listType);
            }
        }
    }

    public static enum PlayerListType {
        AFK("AFK Players"),
        ACTIVE("Active Players");

        private final String friendlyName;

        private PlayerListType(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getTitle() {
            return String.valueOf(ChatColor.DARK_GRAY) + this.friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        public PlayerListType getOpposite() {
            return this == AFK ? ACTIVE : AFK;
        }

        public String getToggleDisplayName() {
            return String.valueOf(ChatColor.AQUA) + "View " + this.getOpposite().getFriendlyName();
        }

        public static PlayerListType fromTitle(String title) {
            for (PlayerListType type : PlayerListType.values()) {
                if (!title.startsWith(type.getTitle())) continue;
                return type;
            }
            return null;
        }
    }
}

