/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.gui;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.compatibility.CompatibilityUtil;
import com.gyvex.ezafk.gui.AfkPlayerOverviewGUI;
import com.gyvex.ezafk.manager.MessageManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AfkPlayerActionsGUI
implements Listener {
    private static final String GUI_TITLE = String.valueOf(ChatColor.DARK_GRAY) + "Player Actions";
    private static final int MIN_INVENTORY_SIZE = 9;
    private static final int MAX_INVENTORY_SIZE = 54;
    private static final HashMap<UUID, UUID> targetPlayers = new HashMap();
    private static final Map<UUID, Integer> returnPages = new HashMap<UUID, Integer>();
    private static final Map<UUID, AfkPlayerOverviewGUI.PlayerListType> returnListTypes = new HashMap<UUID, AfkPlayerOverviewGUI.PlayerListType>();
    private static AfkPlayerActionsGUI instance;
    private final Map<Integer, GuiAction> actions = new HashMap<Integer, GuiAction>();
    private ItemStack backButtonItem;
    private int backButtonSlot = -1;
    private int inventorySize = 9;

    public AfkPlayerActionsGUI() {
        instance = this;
        this.reloadActions();
    }

    public static void reloadConfiguredActions() {
        if (instance != null) {
            instance.reloadActions();
        }
    }

    public static AfkPlayerActionsGUI getInstance() {
        return instance;
    }

    public void openGUI(Player opener, Player targetPlayer) {
        this.openGUI(opener, targetPlayer, 1, AfkPlayerOverviewGUI.PlayerListType.AFK);
    }

    public void openGUI(Player opener, Player targetPlayer, int overviewPage) {
        this.openGUI(opener, targetPlayer, overviewPage, AfkPlayerOverviewGUI.PlayerListType.AFK);
    }

    public void openGUI(Player opener, Player targetPlayer, int overviewPage, AfkPlayerOverviewGUI.PlayerListType listType) {
        UUID openerId = opener.getUniqueId();
        targetPlayers.put(openerId, targetPlayer != null ? targetPlayer.getUniqueId() : null);
        returnPages.put(openerId, Math.max(1, overviewPage));
        returnListTypes.put(openerId, listType != null ? listType : AfkPlayerOverviewGUI.PlayerListType.AFK);
        Inventory inventory = CompatibilityUtil.createInventory(null, this.inventorySize, GUI_TITLE);
        for (Map.Entry<Integer, GuiAction> entry : this.actions.entrySet()) {
            inventory.setItem(entry.getKey().intValue(), entry.getValue().createIcon());
        }
        if (this.backButtonSlot >= 0 && this.backButtonItem != null) {
            inventory.setItem(this.backButtonSlot, this.backButtonItem.clone());
        }
        opener.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = CompatibilityUtil.getInventoryTitle((InventoryEvent)event);
        if (!title.equals(GUI_TITLE)) {
            return;
        }
        if (event.getClickedInventory() == null || event.getView().getTopInventory() != event.getClickedInventory()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        Player player = (Player)event.getWhoClicked();
        if (!player.hasPermission("ezafk.gui.actions") && !player.isOp()) {
            MessageManager.sendMessage((CommandSender)player, "gui.actions.no-permission", "&cYou don't have permission to use player actions.");
            player.closeInventory();
            return;
        }
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.backButtonSlot >= 0 && event.getSlot() == this.backButtonSlot) {
            this.handleBackButtonClick(player);
            return;
        }
        GuiAction action = this.actions.get(event.getSlot());
        if (action == null) {
            return;
        }
        UUID targetPlayerId = targetPlayers.get(player.getUniqueId());
        Player targetPlayer = targetPlayerId != null ? Bukkit.getPlayer((UUID)targetPlayerId) : null;
        action.execute(player, targetPlayer);
        UUID playerId = player.getUniqueId();
        targetPlayers.remove(playerId);
        returnPages.remove(playerId);
        returnListTypes.remove(playerId);
    }

    private void reloadActions() {
        this.actions.clear();
        this.inventorySize = 9;
        this.backButtonSlot = -1;
        this.backButtonItem = this.createBackButtonItem();
        FileConfiguration config = EzAfk.getInstance().getGuiConfig();
        ConfigurationSection section = config.getConfigurationSection("actions");
        int configuredSize = config.getInt("inventory-size", config.getInt("actions.inventory-size", 9));
        this.inventorySize = this.normalizeInventorySize(configuredSize);
        if (section == null) {
            EzAfk.getInstance().getLogger().warning("No GUI actions configured. The player actions GUI will be empty.");
        } else {
            for (String key : section.getKeys(false)) {
                GuiAction.ActionType actionType;
                int slot;
                ConfigurationSection actionSection = section.getConfigurationSection(key);
                if (actionSection == null || (slot = actionSection.getInt("slot", this.actions.size())) < 0) continue;
                if (slot >= 54) {
                    EzAfk.getInstance().getLogger().warning("Slot " + slot + " for GUI action '" + key + "' exceeds the maximum supported size. Skipping...");
                    continue;
                }
                String materialName = actionSection.getString("material", "STONE");
                Material material = null;
                if (materialName != null && (material = Material.matchMaterial((String)materialName)) == null) {
                    material = Material.matchMaterial((String)materialName.toUpperCase(Locale.ROOT));
                }
                if (material == null) {
                    EzAfk.getInstance().getLogger().warning("Invalid material for GUI action '" + key + "'. Skipping...");
                    continue;
                }
                String displayName = actionSection.getString("display-name", key);
                String typeName = actionSection.getString("type", "MESSAGE");
                try {
                    actionType = GuiAction.ActionType.valueOf(typeName.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException exception) {
                    EzAfk.getInstance().getLogger().warning("Invalid action type '" + typeName + "' for GUI action '" + key + "'. Skipping...");
                    continue;
                }
                String targetMessage = actionSection.getString("target-message");
                String feedbackMessage = actionSection.getString("feedback-message");
                String command = actionSection.getString("command");
                GuiAction action = new GuiAction(material, displayName, actionType, targetMessage, feedbackMessage, command);
                this.actions.put(slot, action);
                int requiredSize = (slot / 9 + 1) * 9;
                if (requiredSize > 54) {
                    requiredSize = 54;
                }
                this.inventorySize = Math.max(this.inventorySize, requiredSize);
            }
        }
        this.ensureBackButtonSlot();
    }

    private void handleBackButtonClick(Player player) {
        UUID playerId = player.getUniqueId();
        int page = returnPages.getOrDefault(playerId, 1);
        AfkPlayerOverviewGUI.PlayerListType listType = returnListTypes.getOrDefault(playerId, AfkPlayerOverviewGUI.PlayerListType.AFK);
        targetPlayers.remove(playerId);
        returnPages.remove(playerId);
        returnListTypes.remove(playerId);
        AfkPlayerOverviewGUI overviewGUI = new AfkPlayerOverviewGUI();
        overviewGUI.openGUI(player, page, listType);
    }

    private void ensureBackButtonSlot() {
        if (this.backButtonItem == null) {
            return;
        }
        this.backButtonSlot = this.findAvailableBackSlot();
        while (this.backButtonSlot < 0 && this.inventorySize < 54) {
            this.inventorySize += 9;
            this.backButtonSlot = this.findAvailableBackSlot();
        }
        if (this.backButtonSlot < 0) {
            EzAfk.getInstance().getLogger().warning("Failed to allocate a slot for the back button in the player actions GUI.");
        }
    }

    private int findAvailableBackSlot() {
        for (int slot = this.inventorySize - 1; slot >= 0; --slot) {
            if (this.actions.containsKey(slot)) continue;
            return slot;
        }
        return -1;
    }

    private int normalizeInventorySize(int configuredSize) {
        int size = configuredSize;
        if (size < 9) {
            size = 9;
        } else if (size > 54) {
            size = 54;
        }
        if (size % 9 != 0) {
            size = (size + 8) / 9 * 9;
        }
        if (size != configuredSize) {
            EzAfk.getInstance().getLogger().warning("Adjusted player actions GUI inventory size from " + configuredSize + " to " + size + " (must be a multiple of 9 between 9 and 54).");
        }
        return size;
    }

    private ItemStack createBackButtonItem() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RED) + "Back");
            item.setItemMeta(meta);
        }
        return item;
    }

    private static String replacePlaceholders(Player executor, Player target, String message) {
        if (message == null) {
            return null;
        }
        String result = message;
        result = result.replace("%executor%", executor != null ? executor.getName() : "");
        result = result.replace("%player%", target != null ? target.getName() : "");
        return result;
    }

    private static String colorize(String message) {
        if (message == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static class GuiAction {
        private final Material material;
        private final String displayName;
        private final ActionType type;
        private final String targetMessage;
        private final String feedbackMessage;
        private final String command;

        GuiAction(Material material, String displayName, ActionType type, String targetMessage, String feedbackMessage, String command) {
            this.material = material;
            this.displayName = AfkPlayerActionsGUI.colorize(displayName);
            this.type = type;
            this.targetMessage = targetMessage;
            this.feedbackMessage = feedbackMessage;
            this.command = command;
        }

        ItemStack createIcon() {
            ItemStack item = new ItemStack(this.material);
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.displayName);
                item.setItemMeta(meta);
            }
            return item;
        }

        void execute(Player executor, Player target) {
            switch (this.type.ordinal()) {
                case 0: {
                    if (target == null) {
                        MessageManager.sendMessage((CommandSender)executor, "gui.actions.error.player-not-found", "&cCould not find the selected player.");
                        return;
                    }
                    String kickMessage = AfkPlayerActionsGUI.colorize(AfkPlayerActionsGUI.replacePlaceholders(executor, target, this.targetMessage));
                    String defaultKickMessage = MessageManager.getMessage("gui.actions.default-kick-message", "&cYou were kicked for being AFK too long.");
                    target.kickPlayer(kickMessage != null ? kickMessage : defaultKickMessage);
                    break;
                }
                case 1: {
                    if (target == null) {
                        MessageManager.sendMessage((CommandSender)executor, "gui.actions.error.player-not-found", "&cCould not find the selected player.");
                        return;
                    }
                    String alertMessage = AfkPlayerActionsGUI.colorize(AfkPlayerActionsGUI.replacePlaceholders(executor, target, this.targetMessage));
                    if (alertMessage == null) break;
                    target.sendMessage(alertMessage);
                    break;
                }
                case 2: {
                    if (target == null) {
                        MessageManager.sendMessage((CommandSender)executor, "gui.actions.error.player-not-found", "&cCould not find the selected player.");
                        return;
                    }
                    executor.teleport((Entity)target);
                    break;
                }
                case 3: {
                    String commandToRun = AfkPlayerActionsGUI.replacePlaceholders(executor, target, this.command);
                    if (commandToRun == null || commandToRun.isEmpty()) {
                        MessageManager.sendMessage((CommandSender)executor, "gui.actions.error.no-command", "&cNo command configured for this action.");
                        return;
                    }
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commandToRun);
                    break;
                }
                default: {
                    return;
                }
            }
            String feedback = AfkPlayerActionsGUI.colorize(AfkPlayerActionsGUI.replacePlaceholders(executor, target, this.feedbackMessage));
            if (feedback != null && !feedback.isEmpty()) {
                executor.sendMessage(feedback);
            }
            executor.closeInventory();
        }

        static enum ActionType {
            KICK,
            MESSAGE,
            TELEPORT,
            COMMAND;

        }
    }
}

