/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.event;

import com.gyvex.ezafk.manager.AfkTimeManager;
import com.gyvex.ezafk.manager.EconomyManager;
import com.gyvex.ezafk.state.AfkState;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitListener
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        AfkTimeManager.flushActiveSessions(Map.of(playerId, System.currentTimeMillis()));
        if (!AfkState.afkPlayers.contains(playerId)) {
            AfkState.forgetDisplayName(playerId);
            EconomyManager.onDisable(playerId);
            return;
        }
        AfkState.afkPlayers.remove(playerId);
        AfkState.forgetDisplayName(playerId);
        EconomyManager.onDisable(playerId);
    }
}

