/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.event;

import com.gyvex.ezafk.EzAfk;
import com.gyvex.ezafk.manager.MessageManager;
import com.gyvex.ezafk.state.AfkActivationMode;
import com.gyvex.ezafk.state.AfkReason;
import com.gyvex.ezafk.state.AfkState;
import com.gyvex.ezafk.state.LastActiveState;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class MoveListener
implements Listener {
    private final EzAfk plugin;
    private final Set<UUID> vehicleBypassHandled = new HashSet<UUID>();
    private final Set<UUID> infiniteWaterFlowHandled = new HashSet<UUID>();
    private final Set<UUID> bubbleColumnHandled = new HashSet<UUID>();

    public MoveListener(EzAfk plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        boolean antiVehicle = this.plugin.config.getBoolean("afk.anti.infinite-vehicle");
        boolean flagOnly = this.plugin.config.getBoolean("afk.anti.flag-only");
        if (antiVehicle && player.isInsideVehicle()) {
            if (flagOnly) {
                if (this.vehicleBypassHandled.add(playerId)) {
                    this.markBypass(player, AfkReason.ANTI_VEHICLE, "Vehicle movement detected at " + this.formatLocation(player.getLocation()));
                }
            } else {
                if (this.vehicleBypassHandled.add(playerId)) {
                    MessageManager.sendMessage((CommandSender)player, "anti.vehicle", "&cYou cannot AFK while inside a vehicle.");
                }
                if (player.isInsideVehicle()) {
                    player.leaveVehicle();
                }
            }
            return;
        }
        boolean antiInfiniteWaterFlow = this.plugin.config.getBoolean("afk.anti.infinite-waterflow");
        if (antiInfiniteWaterFlow && this.isInInfiniteWaterFlow(player)) {
            if (flagOnly) {
                if (this.infiniteWaterFlowHandled.add(playerId)) {
                    this.markBypass(player, AfkReason.ANTI_INFINITE_WATER, "Water flow detected at " + this.formatLocation(player.getLocation()));
                }
            } else if (this.infiniteWaterFlowHandled.add(playerId)) {
                MessageManager.sendMessage((CommandSender)player, "anti.infinite-waterflow", "&cYou cannot use water flow to avoid AFK detection.");
            }
            return;
        }
        boolean antiBubbleColumn = this.plugin.config.getBoolean("afk.anti.bubble-column");
        if (antiBubbleColumn && this.isInBubbleColumn(player)) {
            if (flagOnly) {
                if (this.bubbleColumnHandled.add(playerId)) {
                    this.markBypass(player, AfkReason.ANTI_BUBBLE_COLUMN, "Bubble column detected at " + this.formatLocation(player.getLocation()));
                }
            } else if (this.bubbleColumnHandled.add(playerId)) {
                MessageManager.sendMessage((CommandSender)player, "anti.bubble-column", "&cYou cannot use bubble columns to avoid AFK detection.");
            }
            return;
        }
        if (!this.hasMeaningfulPositionChange(event)) {
            return;
        }
        LastActiveState.update(player);
        this.vehicleBypassHandled.remove(playerId);
        this.infiniteWaterFlowHandled.remove(playerId);
        if (AfkState.isAfk(playerId)) {
            AfkState.disable(this.plugin, player);
        }
    }

    private void markBypass(Player player, AfkReason reason, String detail) {
        AfkState.markAfk(this.plugin, player, reason, detail, AfkActivationMode.SILENT);
    }

    private String formatLocation(Location location) {
        if (location.getWorld() == null) {
            return String.format("(%.1f, %.1f, %.1f)", location.getX(), location.getY(), location.getZ());
        }
        return String.format("%s (%.1f, %.1f, %.1f)", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    private boolean hasMeaningfulPositionChange(PlayerMoveEvent event) {
        double dz;
        double dy;
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return false;
        }
        if (from.getWorld() != to.getWorld()) {
            return true;
        }
        double dx = to.getX() - from.getX();
        double distanceSquared = dx * dx + (dy = to.getY() - from.getY()) * dy + (dz = to.getZ() - from.getZ()) * dz;
        return distanceSquared > 1.0E-4;
    }

    private boolean isInInfiniteWaterFlow(Player player) {
        Block feetBlock = player.getLocation().getBlock();
        Block bodyBlock = feetBlock.getRelative(BlockFace.UP);
        return this.isFlowingWaterThatPushes(feetBlock) || this.isFlowingWaterThatPushes(bodyBlock);
    }

    private boolean isFlowingWaterThatPushes(Block block) {
        if (block.getType() != Material.WATER) {
            return false;
        }
        Block below = block.getRelative(BlockFace.DOWN);
        if (below.getType() == Material.BUBBLE_COLUMN) {
            return false;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Levelled)) {
            return false;
        }
        Levelled levelled = (Levelled)blockData;
        int level = levelled.getLevel();
        if (level == 0) {
            return false;
        }
        if (level >= levelled.getMaximumLevel()) {
            return below.isPassable();
        }
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Levelled adjacentLevelled;
            BlockData blockData2;
            Block relative = block.getRelative(face);
            if (relative.isPassable() && relative.getType() != Material.WATER) {
                return true;
            }
            if (relative.getType() != Material.WATER || !((blockData2 = relative.getBlockData()) instanceof Levelled) || (adjacentLevelled = (Levelled)blockData2).getLevel() <= level) continue;
            return true;
        }
        return false;
    }

    boolean isInBubbleColumn(Player player) {
        Block feet = player.getLocation().getBlock();
        Block body = feet.getRelative(BlockFace.UP);
        Block below = feet.getRelative(BlockFace.DOWN);
        return feet.getType() == Material.BUBBLE_COLUMN || body.getType() == Material.BUBBLE_COLUMN || below.getType() == Material.BUBBLE_COLUMN;
    }
}

