/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk.compatibility;

import com.gyvex.ezafk.EzAfk;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class CompatibilityUtil {
    private static final String META_PREFIX = String.valueOf(ChatColor.DARK_GRAY) + "ezafk:";
    private static final boolean PERSISTENT_DATA_AVAILABLE = CompatibilityUtil.isClassAvailable("org.bukkit.persistence.PersistentDataContainer") && CompatibilityUtil.hasMethod(ItemMeta.class, "getPersistentDataContainer");

    public static void kickPlayer(Player player, String message) {
        block7: {
            try {
                Class<?> causeClass = null;
                try {
                    causeClass = Class.forName("org.bukkit.event.player.PlayerKickEvent$Cause");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (causeClass == null) break block7;
                Object pluginCause = null;
                try {
                    pluginCause = Enum.valueOf(causeClass, "PLUGIN");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (pluginCause != null) {
                    player.getClass().getMethod("kick", String.class, causeClass).invoke((Object)player, message, pluginCause);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player.kickPlayer(message);
    }

    private static void setLegacySkullData(ItemStack item) {
        try {
            Class<?> materialDataClass = Class.forName("org.bukkit.material.MaterialData");
            Object skullData = materialDataClass.getConstructor(Material.class, Byte.TYPE).newInstance(item.getType(), (byte)3);
            Method setData = ItemStack.class.getMethod("setData", materialDataClass);
            setData.invoke((Object)item, skullData);
        }
        catch (Exception e) {
            try {
                Method setDurability = ItemStack.class.getMethod("setDurability", Short.TYPE);
                setDurability.invoke((Object)item, (short)3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isLegacyPlayerHead(ItemStack item) {
        try {
            Method getData = ItemStack.class.getMethod("getData", new Class[0]);
            Object data = getData.invoke((Object)item, new Object[0]);
            if (data != null && data.getClass().getMethod("getData", new Class[0]).invoke(data, new Object[0]).equals((byte)3)) {
                return true;
            }
        }
        catch (Exception e) {
            try {
                Method getDurability = ItemStack.class.getMethod("getDurability", new Class[0]);
                Object durability = getDurability.invoke((Object)item, new Object[0]);
                return Short.valueOf((short)3).equals(durability);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Inventory createInventory(InventoryHolder holder, int size, String title) {
        try {
            Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
            Object component = componentClass.getMethod("text", String.class).invoke(null, ChatColor.stripColor((String)title));
            return (Inventory)Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, componentClass).invoke(null, holder, size, component);
        }
        catch (Exception ignored) {
            return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)title);
        }
    }

    public static String getInventoryTitle(InventoryEvent event) {
        try {
            InventoryView view = event.getView();
            Method getTitle = view.getClass().getMethod("getTitle", new Class[0]);
            getTitle.setAccessible(true);
            return (String)getTitle.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack createPlayerHead() {
        Material material = CompatibilityUtil.resolveMaterial("PLAYER_HEAD", "SKULL_ITEM");
        ItemStack head = new ItemStack(material);
        if ("SKULL_ITEM".equals(material.name())) {
            CompatibilityUtil.setLegacySkullData(head);
        }
        return head;
    }

    public static boolean isPlayerHead(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        if ("PLAYER_HEAD".equals(type.name())) {
            return true;
        }
        if ("SKULL_ITEM".equals(type.name())) {
            return CompatibilityUtil.isLegacyPlayerHead(item);
        }
        return false;
    }

    public static void setSkullOwner(SkullMeta meta, OfflinePlayer player) {
        if (meta == null || player == null) {
            return;
        }
        try {
            Method setOwningPlayer = meta.getClass().getMethod("setOwningPlayer", OfflinePlayer.class);
            setOwningPlayer.invoke((Object)meta, player);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException setOwningPlayer) {
            try {
                Method setOwner = meta.getClass().getMethod("setOwner", String.class);
                if (player.getName() != null) {
                    setOwner.invoke((Object)meta, player.getName());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            return;
        }
    }

    public static void setItemMetadata(ItemMeta meta, String key, String value) {
        if (meta == null) {
            return;
        }
        if (PERSISTENT_DATA_AVAILABLE && CompatibilityUtil.setPersistentData(meta, key, value)) {
            return;
        }
        CompatibilityUtil.setLoreMetadata(meta, key, value);
    }

    public static String getItemMetadata(ItemMeta meta, String key) {
        String value;
        if (meta == null) {
            return null;
        }
        if (PERSISTENT_DATA_AVAILABLE && (value = CompatibilityUtil.getPersistentData(meta, key)) != null) {
            return value;
        }
        return CompatibilityUtil.getLoreMetadata(meta, key);
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        if (player == null) {
            return;
        }
        try {
            Method sendTitle = player.getClass().getMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            sendTitle.invoke((Object)player, title, subtitle, fadeIn, stay, fadeOut);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static void playSound(Player player, float volume, float pitch, String ... soundNames) {
        if (player == null || soundNames == null) {
            return;
        }
        for (String soundName : soundNames) {
            if (soundName == null || soundName.isEmpty()) continue;
            try {
                Sound sound = Sound.valueOf((String)soundName);
                player.playSound(player.getLocation(), sound, volume, pitch);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            Method playSound = player.getClass().getMethod("playSound", player.getLocation().getClass(), String.class, Float.TYPE, Float.TYPE);
            playSound.invoke((Object)player, player.getLocation(), soundNames[0], Float.valueOf(volume), Float.valueOf(pitch));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static Material resolveMaterial(String modernName, String legacyName) {
        Material material = CompatibilityUtil.matchMaterial(modernName);
        if (material == null && legacyName != null) {
            material = CompatibilityUtil.matchMaterial(legacyName);
        }
        if (material == null) {
            throw new IllegalArgumentException("Unable to resolve material for " + modernName + " or " + legacyName);
        }
        return material;
    }

    private static Material matchMaterial(String name) {
        if (name == null) {
            return null;
        }
        try {
            Method matchMaterial = Material.class.getMethod("matchMaterial", String.class);
            return (Material)matchMaterial.invoke(null, name);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException matchMaterial) {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
    }

    private static boolean setPersistentData(ItemMeta meta, String key, String value) {
        try {
            Object namespacedKey = CompatibilityUtil.createNamespacedKey(key);
            if (namespacedKey == null) {
                return false;
            }
            Object container = meta.getClass().getMethod("getPersistentDataContainer", new Class[0]).invoke((Object)meta, new Object[0]);
            Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
            Field stringType = persistentDataTypeClass.getField("STRING");
            Object stringTypeInstance = stringType.get(null);
            Method setMethod = container.getClass().getMethod("set", namespacedKey.getClass(), persistentDataTypeClass, Object.class);
            setMethod.invoke(container, namespacedKey, stringTypeInstance, value);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static String getPersistentData(ItemMeta meta, String key) {
        try {
            Object namespacedKey = CompatibilityUtil.createNamespacedKey(key);
            if (namespacedKey == null) {
                return null;
            }
            Object container = meta.getClass().getMethod("getPersistentDataContainer", new Class[0]).invoke((Object)meta, new Object[0]);
            Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
            Field stringType = persistentDataTypeClass.getField("STRING");
            Object stringTypeInstance = stringType.get(null);
            Method getMethod = container.getClass().getMethod("get", namespacedKey.getClass(), persistentDataTypeClass);
            Object value = getMethod.invoke(container, namespacedKey, stringTypeInstance);
            return value instanceof String ? (String)value : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Object createNamespacedKey(String key) {
        try {
            Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
            Constructor<?> constructor = namespacedKeyClass.getConstructor(Plugin.class, String.class);
            return constructor.newInstance(new Object[]{EzAfk.getInstance(), key});
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void setLoreMetadata(ItemMeta meta, String key, String value) {
        String prefix = META_PREFIX + key + ":";
        ArrayList<CallSite> lore = meta.hasLore() ? new ArrayList<CallSite>(meta.getLore()) : new ArrayList();
        Iterator iterator = lore.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line == null || !line.startsWith(prefix)) continue;
            iterator.remove();
        }
        lore.add((CallSite)((Object)(prefix + value)));
        meta.setLore(lore);
    }

    private static String getLoreMetadata(ItemMeta meta, String key) {
        if (!meta.hasLore()) {
            return null;
        }
        String prefix = META_PREFIX + key + ":";
        for (String line : meta.getLore()) {
            if (line == null || !line.startsWith(prefix)) continue;
            return line.substring(prefix.length());
        }
        return null;
    }

    private static boolean isClassAvailable(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean hasMethod(Class<?> type, String name) {
        for (Method method : type.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

