/*
 * Decompiled with CFR 0.152.
 */
package com.gyvex.ezafk;

import com.gyvex.ezafk.command.EzAfkCommand;
import com.gyvex.ezafk.event.MoveListener;
import com.gyvex.ezafk.event.PlayerActivityListener;
import com.gyvex.ezafk.event.PlayerQuitListener;
import com.gyvex.ezafk.gui.AfkPlayerActionsGUI;
import com.gyvex.ezafk.gui.AfkPlayerOverviewGUI;
import com.gyvex.ezafk.integration.EconomyIntegration;
import com.gyvex.ezafk.integration.EconomyServiceListener;
import com.gyvex.ezafk.integration.MetricsIntegration;
import com.gyvex.ezafk.integration.PlaceholderApiIntegration;
import com.gyvex.ezafk.integration.SpigotIntegration;
import com.gyvex.ezafk.integration.TabIntegration;
import com.gyvex.ezafk.integration.WorldGuardIntegration;
import com.gyvex.ezafk.manager.AfkTimeManager;
import com.gyvex.ezafk.manager.EconomyManager;
import com.gyvex.ezafk.manager.IntegrationManager;
import com.gyvex.ezafk.manager.MySQLManager;
import com.gyvex.ezafk.runnable.AfkCheckTask;
import com.gyvex.ezafk.state.AfkState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;

public class EzAfk
extends JavaPlugin {
    public FileConfiguration config;
    private FileConfiguration messagesConfig;
    private FileConfiguration guiConfig;
    private FileConfiguration mysqlConfig;
    private File messagesFile;
    private File guiFile;
    private File mysqlFile;
    private static EzAfk instance;
    private EconomyServiceListener economyServiceListener;

    public void onLoad() {
        instance = this;
        this.saveDefaultConfig();
        this.loadConfig();
        this.maybeRegisterWorldGuardIntegration();
    }

    public void onEnable() {
        this.logStartupBanner();
        IntegrationManager.addIntegration("metrics", new MetricsIntegration());
        IntegrationManager.addIntegration("tab", new TabIntegration());
        IntegrationManager.addIntegration("spigot", new SpigotIntegration());
        IntegrationManager.addIntegration("economy", new EconomyIntegration());
        IntegrationManager.addIntegration("placeholderapi", new PlaceholderApiIntegration());
        IntegrationManager.load();
        MySQLManager.setup();
        AfkTimeManager.load(this);
        this.economyServiceListener = new EconomyServiceListener();
        this.getServer().getPluginManager().registerEvents((Listener)this.economyServiceListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MoveListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerActivityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AfkPlayerOverviewGUI(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AfkPlayerActionsGUI(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(), (Plugin)this);
        this.getCommand("ezafk").setExecutor((CommandExecutor)new EzAfkCommand(this));
        this.startAFKCheckTask();
    }

    private void logStartupBanner() {
        String[] banner;
        for (String line : banner = new String[]{"\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2591\u2588\u2588\u2588\u2588\u2588\u2557\u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557\u2591\u2591\u2588\u2588\u2557", "\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u2588\u2588\u2551\u2591\u2588\u2588\u2554\u255d", "\u2588\u2588\u2588\u2588\u2588\u2557\u2591\u2591\u2591\u2591\u2588\u2588\u2588\u2554\u2550\u255d\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2557\u2591\u2591\u2588\u2588\u2588\u2588\u2588\u2550\u255d\u2591", "\u2588\u2588\u2554\u2550\u2550\u255d\u2591\u2591\u2588\u2588\u2554\u2550\u2550\u255d\u2591\u2591\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d\u2591\u2591\u2588\u2588\u2554\u2550\u2588\u2588\u2557\u2591", "\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2551\u2591\u2591\u2588\u2588\u2551\u2588\u2588\u2551\u2591\u2591\u2591\u2591\u2591\u2588\u2588\u2551\u2591\u255a\u2588\u2588\u2557", "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u255d\u2591\u2591\u255a\u2550\u255d\u255a\u2550\u255d\u2591\u2591\u2591\u2591\u2591\u255a\u2550\u255d\u2591\u2591\u255a\u2550\u255d"}) {
            this.getLogger().info(line);
        }
    }

    public void onDisable() {
        AfkTimeManager.flushActiveSessions(AfkState.getActiveAfkSessions());
        if (this.config.getBoolean("afk.hide-screen.enabled")) {
            for (UUID uuid : new ArrayList<UUID>(AfkState.afkPlayers)) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) continue;
                player.removePotionEffect(PotionEffectType.BLINDNESS);
            }
        }
        AfkState.restoreAllDisplayNames();
        AfkState.afkPlayers.clear();
        AfkState.clearBypass();
        if (this.economyServiceListener != null) {
            HandlerList.unregisterAll((Listener)this.economyServiceListener);
            this.economyServiceListener = null;
        }
        IntegrationManager.unload();
        EconomyManager.reset();
        AfkTimeManager.shutdown();
    }

    private void startAFKCheckTask() {
        new AfkCheckTask().runTaskTimer((Plugin)this, 20L, 20L);
    }

    public void loadConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.saveDefaultGuiConfig();
        this.reloadGuiConfig();
        this.saveDefaultMysqlConfig();
        this.reloadMysqlConfig();
        this.saveDefaultMessages();
        this.reloadMessages();
        EconomyManager.reset();
    }

    public static EzAfk getInstance() {
        return instance;
    }

    public FileConfiguration getMessages() {
        if (this.messagesConfig == null) {
            this.reloadMessages();
        }
        return this.messagesConfig;
    }

    public FileConfiguration getGuiConfig() {
        if (this.guiConfig == null) {
            this.reloadGuiConfig();
        }
        return this.guiConfig;
    }

    public FileConfiguration getMysqlConfig() {
        if (this.mysqlConfig == null) {
            this.reloadMysqlConfig();
        }
        return this.mysqlConfig;
    }

    public void reloadMessages() {
        String fileName = this.getMessagesFileName();
        this.saveDefaultMessages(fileName);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defaultStream = this.getResource(fileName);
        if (defaultStream != null) {
            try (InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);){
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                this.messagesConfig.setDefaults((Configuration)defaultConfig);
                this.messagesConfig.options().copyDefaults(true);
            }
            catch (IOException exception) {
                this.getLogger().log(Level.WARNING, "Failed to load default " + fileName, exception);
            }
        }
    }

    private void saveDefaultMessages() {
        this.saveDefaultMessages(this.getMessagesFileName());
    }

    private void saveDefaultMessages(String fileName) {
        File parent;
        File dataFolder = this.getDataFolder();
        File targetFile = new File(dataFolder, fileName);
        if (this.messagesFile == null || !this.messagesFile.equals(targetFile)) {
            this.messagesFile = targetFile;
        }
        if ((parent = this.messagesFile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (!this.messagesFile.exists()) {
            this.saveResource(fileName, false);
        }
    }

    private String getMessagesFileName() {
        String configured;
        String language = "en";
        if (this.config != null && (configured = this.config.getString("messages.language", "en")) != null) {
            language = configured.trim().toLowerCase(Locale.ROOT);
        }
        switch (language) {
            case "es": {
                return this.resolveMessagesFileName("es", "messages_es.yml");
            }
            case "nl": {
                return this.resolveMessagesFileName("nl", "messages_nl.yml");
            }
            case "ru": {
                return this.resolveMessagesFileName("ru", "messages_ru.yml");
            }
            case "zh": {
                return this.resolveMessagesFileName("zh", "messages_zh.yml");
            }
            case "en": {
                return this.resolveEnglishMessagesFileName();
            }
        }
        this.getLogger().log(Level.WARNING, "Unknown messages.language '" + language + "', defaulting to en");
        return this.resolveEnglishMessagesFileName();
    }

    private String resolveEnglishMessagesFileName() {
        File dataFolder = this.getDataFolder();
        return this.resolveMessagesFileName("en", "messages.yml", "messages_en.yml");
    }

    private String resolveMessagesFileName(String language, String ... legacyFileNames) {
        String newFileName;
        File dataFolder = this.getDataFolder();
        File newFile = new File(dataFolder, newFileName = "messages/" + (String)(language.equals("en") ? "messages" : "messages_" + language) + ".yml");
        if (newFile.exists()) {
            return newFileName;
        }
        for (String legacyFileName : legacyFileNames) {
            File legacyFile = new File(dataFolder, legacyFileName);
            if (!legacyFile.exists()) continue;
            return legacyFileName;
        }
        return newFileName;
    }

    public void reloadGuiConfig() {
        this.saveDefaultGuiConfig();
        if (this.guiFile == null) {
            this.guiFile = new File(this.getDataFolder(), "gui.yml");
        }
        this.guiConfig = YamlConfiguration.loadConfiguration((File)this.guiFile);
        InputStream defaultStream = this.getResource("gui.yml");
        if (defaultStream != null) {
            try (InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);){
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                this.guiConfig.setDefaults((Configuration)defaultConfig);
                this.guiConfig.options().copyDefaults(true);
            }
            catch (IOException exception) {
                this.getLogger().log(Level.WARNING, "Failed to load default gui.yml", exception);
            }
        }
    }

    private void saveDefaultGuiConfig() {
        if (this.guiFile == null) {
            this.guiFile = new File(this.getDataFolder(), "gui.yml");
        }
        if (!this.guiFile.exists()) {
            this.saveResource("gui.yml", false);
        }
    }

    public void reloadMysqlConfig() {
        this.saveDefaultMysqlConfig();
        if (this.mysqlFile == null) {
            this.mysqlFile = new File(this.getDataFolder(), "mysql.yml");
        }
        this.mysqlConfig = YamlConfiguration.loadConfiguration((File)this.mysqlFile);
        InputStream defaultStream = this.getResource("mysql.yml");
        if (defaultStream != null) {
            try (InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);){
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                this.mysqlConfig.setDefaults((Configuration)defaultConfig);
                this.mysqlConfig.options().copyDefaults(true);
            }
            catch (IOException exception) {
                this.getLogger().log(Level.WARNING, "Failed to load default mysql.yml", exception);
            }
        }
    }

    private void saveDefaultMysqlConfig() {
        if (this.mysqlFile == null) {
            this.mysqlFile = new File(this.getDataFolder(), "mysql.yml");
        }
        if (!this.mysqlFile.exists()) {
            this.saveResource("mysql.yml", false);
        }
    }

    private void maybeRegisterWorldGuardIntegration() {
        if (!this.config.getBoolean("integration.worldguard")) {
            this.getLogger().fine("WorldGuard integration disabled via config");
            return;
        }
        Plugin worldGuardPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin == null || !worldGuardPlugin.isEnabled()) {
            this.getLogger().info("WorldGuard plugin not found. Skipping integration setup.");
            return;
        }
        try {
            Class.forName("com.sk89q.worldguard.WorldGuard");
            Class.forName("com.sk89q.worldguard.protection.flags.registry.FlagRegistry");
            Class.forName("com.sk89q.worldguard.protection.flags.StateFlag");
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            this.getLogger().log(Level.WARNING, "WorldGuard classes not present. Skipping integration setup.", ex);
            return;
        }
        try {
            WorldGuardIntegration integration = new WorldGuardIntegration();
            integration.setupTags();
            if (integration.isSetup) {
                IntegrationManager.addIntegration("worldguard", integration);
                this.getLogger().info("WorldGuard integration registered.");
            } else {
                this.getLogger().info("WorldGuard integration setup skipped after tag registration failure.");
            }
        }
        catch (NoClassDefFoundError ex) {
            this.getLogger().log(Level.WARNING, "Failed to initialize WorldGuard integration.", ex);
        }
    }
}

