/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader;

import com.eternalcode.core.loader.dependency.Dependency;
import com.eternalcode.core.loader.relocation.Relocation;
import com.eternalcode.core.loader.repository.Repository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class EternalCoreLoaderConstants {
    private static final String DEPENDENCIES_HOLDER = "io{}papermc:paperlib:1{}0{}8|net{}kyori:adventure-text-minimessage:4{}26{}1|net{}kyori:adventure-platform-bukkit:4{}4{}1|eu{}okaeri:okaeri-configs-core:6{}0{}0-beta{}27|eu{}okaeri:okaeri-configs-yaml-snakeyaml:6{}0{}0-beta{}27|eu{}okaeri:okaeri-configs-serdes-commons:6{}0{}0-beta{}27|com{}eternalcode:multification-bukkit:1{}2{}4|com{}eternalcode:multification-okaeri:1{}2{}4|com{}github{}cryptomorin:XSeries:13{}6{}0|com{}eternalcode:eternalcode-commons-bukkit:1{}3{}2|com{}eternalcode:eternalcode-commons-adventure:1{}3{}2|com{}eternalcode:eternalcode-commons-folia:1{}3{}2|com{}eternalcode:eternalcode-commons-updater:1{}3{}2|org{}mariadb{}jdbc:mariadb-java-client:3{}5{}7|org{}postgresql:postgresql:42{}7{}9|com{}h2database:h2:2{}4{}240|com{}j256{}ormlite:ormlite-core:6{}1|com{}j256{}ormlite:ormlite-jdbc:6{}1|com{}zaxxer:HikariCP:7{}0{}2|dev{}rollczi:liteskullapi:2{}0{}0|dev{}rollczi:litecommands-bukkit:3{}10{}9|dev{}rollczi:litecommands-folia:3{}10{}9|dev{}rollczi:litecommands-adventure-platform:3{}10{}9|commons-io:commons-io:2{}21{}0|dev{}triumphteam:triumph-gui:3{}1{}13|org{}bstats:bstats-bukkit:3{}1{}0|com{}github{}ben-manes{}caffeine:caffeine:3{}2{}3|fr{}skytasul:glowingentities:1{}4{}10";
    private static final String REPOSITORIES_HOLDER = "https://maven-central.storage-download.googleapis.com/maven2|https://hub.spigotmc.org/nexus/content/repositories/snapshots/|https://repo.papermc.io/repository/maven-public/|https://repo.panda-lang.org/releases/|https://repo.eternalcode.pl/releases/|https://repo.extendedclip.com/content/repositories/placeholderapi/|https://repo.stellardrift.ca/repository/snapshots/|https://storehouse.okaeri.eu/repository/maven-public/|https://repo.mikeprimm.com/";
    private static final String RELOCATIONS_HOLDER = "io{}papermc{}lib|net{}kyori|eu{}okaeri|com{}eternalcode{}multification|com{}cryptomorin{}xseries|com{}eternalcode{}commons|com{}zaxxer{}hikari|com{}j256{}ormlite|org{}mariadb{}jdbc|org{}postgresql|com{}h2|dev{}rollczi{}litecommands|dev{}rollczi{}liteskullapi|org{}apache{}commons{}io|dev{}triumphteam|org{}bstats|com{}github{}benmanes{}caffeine|fr{}skytasul";
    private static final List<Relocation> RELOCATIONS = EternalCoreLoaderConstants.createRelocations();
    private static final String RELOCATION_PREFIX = "com{}eternalcode{}core{}libs{}";

    private EternalCoreLoaderConstants() {
        throw new UnsupportedOperationException("This class cannot be instantiated!");
    }

    public static List<Dependency> dependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String rawDependency : DEPENDENCIES_HOLDER.split("\\|")) {
            String[] dependencyData = rawDependency.split(":");
            if (dependencyData.length != 3) {
                throw new IllegalStateException("Dependency " + rawDependency + " is not valid!");
            }
            String groupId = dependencyData[0];
            String artifactId = dependencyData[1];
            String version = dependencyData[2];
            Dependency dependency = Dependency.of(groupId, artifactId, version);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public static List<Repository> repositories() {
        return Arrays.stream(REPOSITORIES_HOLDER.split("\\|")).map(Repository::of).toList();
    }

    public static List<Relocation> relocations() {
        return RELOCATIONS;
    }

    private static List<Relocation> createRelocations() {
        return Arrays.stream(RELOCATIONS_HOLDER.split("\\|")).map(rawRelocation -> new Relocation((String)rawRelocation, RELOCATION_PREFIX + rawRelocation)).toList();
    }
}

