/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.injector.bean;

import com.eternalcode.core.injector.bean.BeanHolder;
import com.eternalcode.core.injector.bean.PrioritizedBeanCandidate;
import com.eternalcode.core.injector.bean.SimpleBeanCandidate;
import com.eternalcode.core.libs.dev.rollczi.litecommands.priority.Prioritized;
import com.eternalcode.core.libs.dev.rollczi.litecommands.priority.PriorityLevel;
import java.util.function.Supplier;

public interface BeanCandidate
extends Prioritized {
    public boolean isCandidate(Class<?> var1);

    public Class<?> getType();

    public <T> BeanHolder<T> createBean(Class<T> var1);

    default public PriorityLevel getPriority() {
        return PriorityLevel.NORMAL;
    }

    public static <T> BeanCandidate of(String name, Class<T> type, Supplier<T> instance) {
        return new SimpleBeanCandidate(name, type, instance);
    }

    public static <T> BeanCandidate of(Class<T> type, Supplier<T> instance) {
        return new SimpleBeanCandidate("", type, instance);
    }

    public static BeanCandidate prioritized(BeanCandidate candidate, PriorityLevel priorityLevel) {
        return new PrioritizedBeanCandidate(candidate, priorityLevel);
    }
}

