/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.time;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.List;
import org.bukkit.command.CommandSender;

@LiteArgument(type=int.class, name="time")
class TimeArgument
extends AbstractViewerArgument<Integer> {
    private static final List<Integer> suggestions = List.of(Integer.valueOf(1000), Integer.valueOf(6000), Integer.valueOf(13000), Integer.valueOf(18000));
    static final String KEY = "time";

    @Inject
    public TimeArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<Integer> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            int value = Integer.parseInt(argument);
            if (value < 0) {
                return ParseResult.failure((Object)translation.argument().numberBiggerThanOrEqualZero());
            }
            return ParseResult.success((Object)value);
        }
        catch (NumberFormatException exception) {
            return ParseResult.failure((Object)translation.argument().numberBiggerThanOrEqualZero());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Integer> argument, SuggestionContext context) {
        return (SuggestionResult)suggestions.stream().map(String::valueOf).collect(SuggestionResult.collector());
    }
}

