/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.catboy;

import com.eternalcode.core.feature.catboy.Catboy;
import com.eternalcode.core.feature.catboy.CatboyService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Task;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import java.awt.Color;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Task(delay=400L, period=400L, unit=TimeUnit.MILLISECONDS)
class CatboyTask
implements Runnable {
    private static final String CATBOY_NAME = "Catboy";
    private static final int PARTICLES_COUNT = 4;
    private final CatboyService catboyService;
    private final Server server;
    private final MinecraftScheduler scheduler;

    @Inject
    CatboyTask(CatboyService catboyService, Server server, MinecraftScheduler scheduler) {
        this.catboyService = catboyService;
        this.server = server;
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        for (Catboy catboy : this.catboyService.getCatboys()) {
            Player player = this.server.getPlayer(catboy.uuid());
            if (player == null) continue;
            this.animateCatboy(player);
        }
    }

    private void animateCatboy(Player player) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 4; ++i) {
            player.getWorld().spawnParticle(Particle.HEART, player.getLocation().add(random.nextDouble(-1.5, 1.5), random.nextDouble(0.0, 2.0), random.nextDouble(-1.5, 1.5)), 3);
        }
        for (Entity passenger : player.getPassengers()) {
            if (!(passenger instanceof Cat)) continue;
            Cat cat = (Cat)passenger;
            DyeColor dyeColor = this.randomDyeColor();
            Color color = new Color(dyeColor.getColor().asRGB());
            this.scheduler.run((Entity)cat, () -> {
                cat.setCollarColor(dyeColor);
                cat.setCustomName(String.valueOf(ChatColor.of((Color)color)) + CATBOY_NAME);
                cat.setRotation(player.getLocation().getYaw(), cat.getLocation().getPitch());
            });
            break;
        }
    }

    private DyeColor randomDyeColor() {
        return DyeColor.values()[ThreadLocalRandom.current().nextInt(DyeColor.values().length)];
    }
}

