/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.bridge.placeholderapi;

import com.eternalcode.core.bridge.BridgeInitializer;
import com.eternalcode.core.placeholder.PlaceholderRaw;
import com.eternalcode.core.placeholder.PlaceholderRegistry;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderApiExtension
extends PlaceholderExpansion
implements BridgeInitializer {
    private final PlaceholderRegistry placeholderRegistry;
    private final PluginDescriptionFile pluginDescriptionFile;

    public PlaceholderApiExtension(PlaceholderRegistry placeholderRegistry, PluginDescriptionFile pluginDescriptionFile) {
        this.placeholderRegistry = placeholderRegistry;
        this.pluginDescriptionFile = pluginDescriptionFile;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        Optional<PlaceholderRaw> optional = this.placeholderRegistry.getRawPlaceholder(params);
        if (optional.isPresent()) {
            return optional.get().rawApply(player);
        }
        return "Unknown placeholder!";
    }

    @NotNull
    public String getIdentifier() {
        return "eternalcore";
    }

    @NotNull
    public String getAuthor() {
        return "EternalCodeTeam";
    }

    @NotNull
    public String getVersion() {
        return this.pluginDescriptionFile.getVersion();
    }

    @Override
    public void initialize() {
        this.register();
    }
}

