/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.annotations.scan;

import com.eternalcode.annotations.scan.EternalScanRecord;
import com.eternalcode.annotations.scan.EternalScanResolver;
import com.eternalcode.annotations.scan.reflect.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Stream;

public abstract class GroupAnnotationScanResolver<A extends Annotation, GROUP extends Annotation, RESULT>
implements EternalScanResolver<RESULT> {
    private final Class<GROUP> annotationGroupClass;

    public GroupAnnotationScanResolver(Class<GROUP> annotationGroupClass) {
        this.annotationGroupClass = annotationGroupClass;
    }

    @Override
    public final List<RESULT> resolve(EternalScanRecord record) {
        return AnnotationUtil.scanForAnnotations(record.clazz(), this.annotationGroupClass).stream().flatMap(group -> this.resolveGroup(record, group).stream()).toList();
    }

    private List<RESULT> resolveGroup(EternalScanRecord record, GROUP group) {
        return Stream.of(this.getAnnotationsForGroup((Annotation)group)).map(annotation -> this.resolve(record, group, annotation)).toList();
    }

    protected abstract A[] getAnnotationsForGroup(GROUP var1);

    protected abstract RESULT resolve(EternalScanRecord var1, GROUP var2, A var3);
}

