/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.placeholder;

import com.eternalcode.annotations.scan.placeholder.PlaceholdersDocs;
import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.placeholder.Placeholder;
import com.eternalcode.core.placeholder.PlaceholderRegistry;
import com.eternalcode.core.placeholder.PlaceholdersSettings;
import com.eternalcode.core.publish.Subscribe;
import com.eternalcode.core.publish.event.EternalInitializeEvent;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@PlaceholdersDocs(placeholders={@PlaceholdersDocs.Entry(name="online", description="Returns the number of online players who are not vanished", returnType=PlaceholdersDocs.Entry.Type.INT, requiresPlayer=false)})
@Controller
class PlaceholdersSetup {
    PlaceholdersSetup() {
    }

    @Subscribe(value=EternalInitializeEvent.class)
    void setUp(PlaceholderRegistry placeholders, PlaceholdersSettings config) {
        for (String key : config.placeholders().keySet()) {
            placeholders.register(Placeholder.of(key, player -> config.placeholders().getOrDefault(key, "{" + key + "}")));
        }
    }

    @Subscribe(value=EternalInitializeEvent.class)
    void setUpPlaceholders(PlaceholderRegistry placeholders, Server server, VanishService vanishService) {
        placeholders.register(Placeholder.ofLong("online", player -> server.getOnlinePlayers().stream().filter(onlinePlayer -> !vanishService.isVanished((Player)onlinePlayer)).count()));
    }
}

