/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.argument;

import com.eternalcode.core.feature.gamemode.GameModeArgumentSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.litecommand.argument.ArgumentParser;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.Locale;
import java.util.function.Function;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;

@LiteArgument(type=GameMode.class)
class GameModeArgument
extends AbstractViewerArgument<GameMode> {
    private final GameModeArgumentSettings gameModeArgumentSettings;
    private final ArgumentParser<String, GameMode> gameModeArgumentParser;

    @Inject
    GameModeArgument(TranslationManager translationManager, GameModeArgumentSettings gameModeArgumentSettings) {
        super(translationManager);
        this.gameModeArgumentSettings = gameModeArgumentSettings;
        this.gameModeArgumentParser = this.createGameModeArgumentParser();
    }

    @Override
    public ParseResult<GameMode> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        String normalizedInput = argument.trim().toUpperCase(Locale.ROOT);
        Function<String, ParseResult<GameMode>> finalParser = this.gameModeArgumentParser.buildWithFinalFailure(input -> ParseResult.failure((Object)translation.gamemode().gamemodeTypeInvalid()));
        return finalParser.apply(normalizedInput);
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<GameMode> argument, SuggestionContext context) {
        return (SuggestionResult)this.gameModeArgumentSettings.getAvailableAliases().stream().collect(SuggestionResult.collector());
    }

    private ArgumentParser<String, GameMode> createGameModeArgumentParser() {
        return ArgumentParser.of().thenTry(this::parseDirectGameMode).thenTry(this::parseFromAliases);
    }

    private ParseResult<GameMode> parseDirectGameMode(String normalizedInput) {
        try {
            GameMode gameMode = GameMode.valueOf((String)normalizedInput);
            return ParseResult.success((Object)gameMode);
        }
        catch (IllegalArgumentException exception) {
            return ParseResult.failure((Object)new Object());
        }
    }

    private ParseResult<GameMode> parseFromAliases(String normalizedInput) {
        return (ParseResult)this.gameModeArgumentSettings.getByAlias(normalizedInput).map(ParseResult::success).orElseGet(() -> ParseResult.failure((Object)new Object()));
    }
}

