/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.injector.bean;

import com.eternalcode.core.injector.bean.BeanCandidate;
import com.eternalcode.core.injector.bean.BeanHolder;
import java.util.function.Supplier;

public class LazyBeanCandidate
implements BeanCandidate {
    private final String name;
    private final Supplier<Object> instanceSupplier;
    private Object instance;

    public LazyBeanCandidate(String name, Supplier<Object> instanceSupplier) {
        this.name = name;
        this.instanceSupplier = instanceSupplier;
    }

    @Override
    public boolean isCandidate(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getType());
    }

    @Override
    public Class<?> getType() {
        return this.getInstance().getClass();
    }

    @Override
    public <T> BeanHolder<T> createBean(Class<T> clazz) {
        if (!this.isCandidate(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a candidate for " + this.getInstance().getClass().getName());
        }
        return BeanHolder.of(this.name, clazz.cast(this.getInstance()));
    }

    private Object getInstance() {
        if (this.instance == null) {
            this.instance = this.instanceSupplier.get();
        }
        return this.instance;
    }

    public String toString() {
        return "LazyBeanCandidate{instance=" + String.valueOf(this.instance) + "}";
    }
}

