/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.vanish.controller;

import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.feature.vanish.VanishSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.Cache;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.Caffeine;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.RemovalCause;
import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.RemovalListener;
import com.eternalcode.core.notice.NoticeService;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Controller
class OpenSilentController
implements Listener {
    private static final Vector ZERO_VELOCITY = new Vector(0.0, 0.0, 0.0);
    private static final int TICK_DURATION_MILLIS = 50;
    private static final int CACHE_EXPIRE_SECONDS = 5;
    private final NoticeService noticeService;
    private final VanishService vanishService;
    private final VanishSettings config;
    private final Scheduler scheduler;
    private final Cache<UUID, ContainerWrapper> containerCache;

    @Inject
    OpenSilentController(NoticeService noticeService, VanishService vanishService, VanishSettings config, Scheduler scheduler) {
        this.noticeService = noticeService;
        this.vanishService = vanishService;
        this.config = config;
        this.scheduler = scheduler;
        this.containerCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).removalListener((RemovalListener)new PlayerRestoreListener(scheduler)).build();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    void handlePlayerInteract(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.vanishService.isVanished(player)) {
            return;
        }
        if (!this.config.silentInventoryAccess()) {
            event.setCancelled(true);
            this.noticeService.player(player.getUniqueId(), message -> message.vanish().cantOpenInventoryWhileVanished(), new Formatter[0]);
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        Material type = clickedBlock.getType();
        if (type == Material.ENDER_CHEST) {
            event.setCancelled(true);
            player.openInventory(player.getEnderChest());
            return;
        }
        if (!this.isContainerType(type) || !(clickedBlock.getState() instanceof Container)) {
            return;
        }
        this.switchForOneTick(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void handlePlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        if (cause == PlayerTeleportEvent.TeleportCause.SPECTATE) {
            return;
        }
        if (this.containerCache.getIfPresent((Object)player.getUniqueId()) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        ContainerWrapper data = (ContainerWrapper)this.containerCache.getIfPresent((Object)playerId);
        if (data != null) {
            this.containerCache.invalidate((Object)playerId);
            data.apply(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void handleInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!this.vanishService.isVanished(player)) {
            return;
        }
        if (event.getInventory() instanceof CraftingInventory) {
            return;
        }
        if (this.containerCache.getIfPresent((Object)player.getUniqueId()) == null) {
            this.switchForOneTick(player);
        }
    }

    private void switchForOneTick(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.containerCache.getIfPresent((Object)playerId) != null) {
            return;
        }
        ContainerWrapper playerData = new ContainerWrapper(player.getGameMode(), player.getAllowFlight(), player.isFlying());
        this.containerCache.put((Object)playerId, (Object)playerData);
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setVelocity(ZERO_VELOCITY);
        player.setGameMode(GameMode.SPECTATOR);
        this.scheduler.runLater(() -> this.restorePlayer(playerId), Duration.ofMillis(50L));
    }

    private void restorePlayer(UUID playerId) {
        ContainerWrapper data = (ContainerWrapper)this.containerCache.getIfPresent((Object)playerId);
        if (data != null) {
            this.containerCache.invalidate((Object)playerId);
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && player.isOnline()) {
                data.apply(player);
            }
        }
    }

    private boolean isContainerType(Material type) {
        return switch (type) {
            case Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL, Material.ENDER_CHEST -> true;
            default -> Tag.SHULKER_BOXES.isTagged((Keyed)type);
        };
    }

    private record PlayerRestoreListener(Scheduler scheduler) implements RemovalListener<UUID, ContainerWrapper>
    {
        public void onRemoval(UUID playerId, ContainerWrapper data, @NotNull RemovalCause cause) {
            if (cause == RemovalCause.EXPIRED && data != null) {
                this.scheduler.run(() -> {
                    Player player = Bukkit.getPlayer((UUID)playerId);
                    if (player != null && player.isOnline()) {
                        data.apply(player);
                    }
                });
            }
        }
    }

    private record ContainerWrapper(GameMode gameMode, boolean allowFlight, boolean isFlying) {
        public void apply(Player player) {
            if (player.isOnline()) {
                player.setGameMode(this.gameMode);
                player.setAllowFlight(this.allowFlight);
                player.setFlying(this.isFlying);
            }
        }
    }
}

