/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.home;

import com.eternalcode.core.feature.home.HomesSettings;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class HomesConfig
extends OkaeriConfig
implements HomesSettings {
    @Comment(value={"# Default home name when no specific name is provided", "# This name will be used when player uses /sethome without specifying a name"})
    public String defaultName = "home";
    @Comment(value={"# Delay before teleportation", "# Time to wait before teleporting player to their home", "# During this time, movement or damage may cancel the teleportation", "# Format: Duration (e.g., 5s for 5 seconds, 1m30s for 1 minute 30 seconds)"})
    public Duration delay = Duration.ofSeconds(5L);
    @Comment(value={"# Maximum number of homes per permission group", "# Configure how many homes players can set based on their permissions", "# ", "# Permission format: 'permission' -> max_homes", "# Players with higher permissions will get the highest limit they qualify for", "# ", "# Default permissions:", "# - eternalcore.home.default: Basic players (1 home)", "# - eternalcore.home.vip: VIP players (2 homes)", "# - eternalcore.home.premium: Premium players (3 homes)", "# ", "# You can add custom permission groups and limits as needed", "# Example: 'eternalcore.home.admin' -> 999"})
    public Map<String, Integer> maxHomes = new LinkedHashMap<String, Integer>(){
        {
            this.put("eternalcore.home.default", 1);
            this.put("eternalcore.home.vip", 2);
            this.put("eternalcore.home.premium", 3);
        }
    };

    @Override
    @Generated
    public String defaultName() {
        return this.defaultName;
    }

    @Override
    @Generated
    public Duration delay() {
        return this.delay;
    }

    @Override
    @Generated
    public Map<String, Integer> maxHomes() {
        return this.maxHomes;
    }
}

