/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.endscreen;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.compatibility.Compatibility;
import com.eternalcode.core.compatibility.Version;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.paper.PaperOverlay;
import org.bukkit.entity.Player;

@Command(name="endscreen", aliases={"end-screen", "win-screen"})
@Permission(value={"eternalcore.endscreen"})
@Compatibility(from=@Version(minor=19, patch=4))
public class EndScreenCommand {
    private final NoticeService noticeService;

    @Inject
    public EndScreenCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Show a end screen to yourself"})
    void self(@Sender Player sender) {
        PaperOverlay.END_SCREEN.show(sender);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.endScreen().shownToSelf())).player(sender.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Show a end screen to a player"}, arguments={"<player>"})
    void other(@Sender Player sender, @Arg Player target) {
        PaperOverlay.END_SCREEN.show(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.endScreen().shownToOtherPlayer())).player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).send();
    }
}

