/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.adminchat;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.adminchat.AdminChatService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.join.Join;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Command(name="adminchat", aliases={"ac"})
@Permission(value={"eternalcore.adminchat"})
final class AdminChatCommand {
    private final AdminChatService adminChatService;
    private final NoticeService noticeService;

    @Inject
    AdminChatCommand(@NotNull AdminChatService adminChatService, @NotNull NoticeService noticeService) {
        this.adminChatService = adminChatService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Toggles persistent admin chat mode. When enabled, all your messages will be sent to admin chat."})
    void executeToggle(@Context @NotNull Player sender) {
        boolean enabled = this.adminChatService.toggleChat(sender.getUniqueId());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> enabled ? translation.adminChat().enabled() : translation.adminChat().disabled())).player(sender.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Sends a message to all staff members with admin chat permissions."}, arguments={"<message>"})
    void executeSendMessage(@Context @NotNull CommandSender sender, @Join @NotNull String message) {
        if (message.trim().isEmpty()) {
            ((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.argument().noArgument())).sender(sender).send();
            return;
        }
        this.adminChatService.sendAdminChatMessage(message, sender);
    }
}

