/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.configuration;

import com.eternalcode.core.configuration.CdnConfigMigrator;
import com.eternalcode.core.configuration.ConfigurationSerdesSetupEvent;
import com.eternalcode.core.configuration.CustomSnakeYamlRepresenter;
import com.eternalcode.core.configuration.EternalConfigurationFile;
import com.eternalcode.core.configuration.migrations.Migrations;
import com.eternalcode.core.configuration.serializer.LanguageSerializer;
import com.eternalcode.core.configuration.transformer.PositionTransformer;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.resolver.NoticeResolverRegistry;
import com.eternalcode.core.libs.com.eternalcode.multification.okaeri.MultificationNoticeSerializer;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.configurer.Configurer;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.OkaeriSerdes;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.commons.SerdesCommons;
import com.eternalcode.core.libs.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import com.eternalcode.core.publish.Publisher;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

@Service
public class ConfigurationManager {
    private final Set<OkaeriConfig> configs = new HashSet<OkaeriConfig>();
    private final Publisher publisher;
    private final NoticeResolverRegistry resolverRegistry;
    private final File dataFolder;

    @Inject
    public ConfigurationManager(NoticeResolverRegistry resolverRegistry, Publisher publisher, File dataFolder) {
        this.resolverRegistry = resolverRegistry;
        this.publisher = publisher;
        this.dataFolder = dataFolder;
    }

    public <T extends OkaeriConfig> T load(T config) {
        File file = ((EternalConfigurationFile)config).getConfigFile(this.dataFolder);
        Yaml yaml = this.createYaml();
        YamlSnakeYamlConfigurer yamlConfigurer = new YamlSnakeYamlConfigurer(this::createYaml);
        CdnConfigMigrator migrator = new CdnConfigMigrator(yaml);
        migrator.runMigrations(file);
        OkaeriSerdesPack serdesPack = registry -> {
            registry.register((BidirectionalTransformer)new PositionTransformer());
            registry.register((ObjectSerializer)new LanguageSerializer());
            registry.register((ObjectSerializer)new MultificationNoticeSerializer(this.resolverRegistry));
            registry.register((OkaeriSerdes)new SerdesCommons());
            this.publisher.publish(new ConfigurationSerdesSetupEvent(registry));
        };
        config.withConfigurer((Configurer)yamlConfigurer).withSerdesPack((OkaeriSerdes)serdesPack).withBindFile(file).saveDefaults().load(true).migrate(Migrations.ALL);
        this.configs.add(config);
        return config;
    }

    private Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        dumperOptions.setIndent(2);
        dumperOptions.setIndicatorIndent(0);
        dumperOptions.setSplitLines(false);
        CustomSnakeYamlRepresenter representer = new CustomSnakeYamlRepresenter(dumperOptions);
        Resolver resolver = new Resolver();
        return new Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions, resolver);
    }

    public void reload() {
        for (OkaeriConfig config : this.configs) {
            config.load();
        }
    }

    public void save(OkaeriConfig config) {
        config.save();
    }

    public Set<OkaeriConfig> getConfigs() {
        return Collections.unmodifiableSet(this.configs);
    }

    public File getDataFolder() {
        return this.dataFolder;
    }
}

