/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleport;

import com.eternalcode.core.feature.teleport.Teleport;
import com.eternalcode.core.feature.teleport.TeleportResult;
import com.eternalcode.core.feature.teleport.TeleportService;
import com.eternalcode.core.feature.teleport.TeleportTaskService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Task;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.Position;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.DurationUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Task(delay=1L, period=1L, unit=TimeUnit.SECONDS)
class TeleportTask
implements Runnable {
    private static final int SECONDS_OFFSET = 1;
    private static final double MOVEMENT_THRESHOLD = 0.5;
    private static final String EMPTY_STRING = "";
    private final NoticeService noticeService;
    private final TeleportTaskService teleportTaskService;
    private final TeleportService teleportService;
    private final Server server;

    @Inject
    TeleportTask(NoticeService noticeService, TeleportTaskService teleportTaskService, TeleportService teleportService, Server server) {
        this.noticeService = noticeService;
        this.teleportTaskService = teleportTaskService;
        this.teleportService = teleportService;
        this.server = server;
    }

    @Override
    public void run() {
        List<Teleport> teleports = List.copyOf(this.teleportTaskService.getTeleports());
        for (Teleport teleport : teleports) {
            Instant teleportMoment;
            UUID uuid = teleport.getPlayerUniqueId();
            Player player = this.server.getPlayer(uuid);
            if (player == null) {
                this.teleportTaskService.removeTeleport(uuid);
                continue;
            }
            if (this.hasPlayerMovedDuringTeleport(player, teleport)) {
                this.teleportTaskService.removeTeleport(uuid);
                teleport.completeResult(TeleportResult.MOVED_DURING_TELEPORT);
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> Notice.actionbar((String)EMPTY_STRING))).notice(translation -> translation.teleport().teleportTaskCanceled())).player(player.getUniqueId())).send();
                continue;
            }
            Instant now = Instant.now();
            if (now.isBefore(teleportMoment = teleport.getTeleportMoment())) {
                Duration duration = Duration.between(now, teleportMoment);
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleportTimerFormat())).placeholder("{TIME}", DurationUtil.format(duration.plusSeconds(1L), true))).player(player.getUniqueId())).send();
                continue;
            }
            this.completeTeleport(player, teleport);
        }
    }

    private void completeTeleport(Player player, Teleport teleport) {
        Location destinationLocation = PositionAdapter.convert((Position)teleport.getDestinationLocation());
        UUID uuid = teleport.getPlayerUniqueId();
        this.teleportService.teleport(player, destinationLocation);
        this.teleportTaskService.removeTeleport(uuid);
        teleport.completeResult(TeleportResult.SUCCESS);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleported())).player(player.getUniqueId())).send();
    }

    private boolean hasPlayerMovedDuringTeleport(Player player, Teleport teleport) {
        Location startLocation = PositionAdapter.convert((Position)teleport.getStartLocation());
        Location currentLocation = player.getLocation();
        if (!currentLocation.getWorld().equals((Object)startLocation.getWorld())) {
            return true;
        }
        return currentLocation.distance(startLocation) > 0.5;
    }
}

