/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.home.command;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.home.HomeService;
import com.eternalcode.core.feature.home.HomesSettings;
import com.eternalcode.core.feature.home.event.HomeLimitReachedEvent;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.user.User;
import java.util.UUID;
import org.bukkit.entity.Player;

@Command(name="sethome")
@Permission(value={"eternalcore.sethome"})
class SetHomeCommand {
    private final HomeService homeService;
    private final NoticeService noticeService;
    private final HomesSettings homesSettings;
    private final EventCaller eventCaller;

    @Inject
    SetHomeCommand(HomeService homeService, NoticeService noticeService, HomesSettings homesSettings, EventCaller eventCaller) {
        this.homeService = homeService;
        this.noticeService = noticeService;
        this.homesSettings = homesSettings;
        this.eventCaller = eventCaller;
    }

    @Execute
    @DescriptionDocs(description={"Set home location with specified name"}, arguments={"<home>"})
    void execute(@Sender User user, @Sender Player player, @Arg String home) {
        this.setOrOverrideHome(user, player, home);
    }

    @Execute
    @DescriptionDocs(description={"Set home location"})
    void execute(@Sender User user, @Sender Player player) {
        this.setOrOverrideHome(user, player, this.homesSettings.defaultName());
    }

    private void setOrOverrideHome(User user, Player player, String homeName) {
        int maxAmountOfUserHomes;
        UUID uniqueId = user.getUniqueId();
        if (this.homeService.hasHome(uniqueId, homeName)) {
            this.homeService.createHome(uniqueId, homeName, player.getLocation());
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().user(user).placeholder("{HOME}", homeName)).notice(translation -> translation.home().overrideHomeLocation())).send();
            return;
        }
        int amountOfUserHomes = this.homeService.getHomes(player.getUniqueId()).size();
        if (amountOfUserHomes >= (maxAmountOfUserHomes = this.homeService.getHomeLimit(player))) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().user(user).placeholder("{LIMIT}", String.valueOf(maxAmountOfUserHomes))).notice(translation -> translation.home().limit())).send();
            this.eventCaller.callEvent(new HomeLimitReachedEvent(player.getUniqueId(), maxAmountOfUserHomes, amountOfUserHomes));
            return;
        }
        this.homeService.createHome(uniqueId, homeName, player.getLocation());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().user(user).notice(translation -> translation.home().create())).placeholder("{HOME}", homeName)).send();
    }
}

