/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.heal;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.PotionEffectUtil;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

@Command(name="heal")
class HealCommand {
    private final NoticeService noticeService;

    @Inject
    HealCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @Permission(value={"eternalcore.heal"})
    @DescriptionDocs(description={"Heal yourself"})
    void healSelf(@Sender Player player) {
        this.heal(player);
        this.noticeService.player(player.getUniqueId(), translation -> translation.heal().healed(), new Formatter[0]);
    }

    @Execute
    @Permission(value={"eternalcore.heal.other"})
    @DescriptionDocs(description={"Heal other player"}, arguments={"<player>"})
    void healOther(@Sender Viewer viewer, @Arg Player target) {
        this.heal(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.heal().healed())).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.heal().healedTargetPlayer())).placeholder("{PLAYER}", target.getName())).viewer(viewer)).send();
    }

    private void heal(Player player) {
        double maxHealth = player.getMaxHealth();
        player.setHealth(maxHealth);
        player.setFoodLevel(20);
        player.setFireTicks(0);
        player.setRemainingAir(player.getMaximumAir());
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (!PotionEffectUtil.isNegativeEffect(effect.getType())) continue;
            player.removePotionEffect(effect.getType());
        }
    }
}

