/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.catboy;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.catboy.CatboyService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import java.util.Optional;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Player;

@Command(name="catboy")
@Permission(value={"eternalcore.catboy"})
class CatboyCommand {
    private final CatboyService catboyService;

    @Inject
    CatboyCommand(CatboyService catboyService) {
        this.catboyService = catboyService;
    }

    @Execute
    @DescriptionDocs(description={"Mark yourself as a catboy."}, arguments={"[type]"})
    void executeCatboySelf(@Sender Player player, @Arg(value="type") Optional<Cat.Type> type) {
        this.switchCatboy(player, type);
    }

    @Execute
    @DescriptionDocs(description={"Mark a player as a catboy."}, arguments={"<player> [type]"})
    @Permission(value={"eternalcore.catboy.others"})
    void executeCatboy(@Arg(value="target") Player target, @Arg(value="type") Optional<Cat.Type> type) {
        this.switchCatboy(target, type);
    }

    private void switchCatboy(Player target, Optional<Cat.Type> type) {
        if (this.catboyService.isCatboy(target.getUniqueId())) {
            if (type.isPresent()) {
                this.catboyService.changeCatboyType(target, type.get());
                return;
            }
            this.catboyService.unmarkAsCatboy(target);
            return;
        }
        this.catboyService.markAsCatboy(target, type.orElse(Cat.Type.BLACK));
    }
}

