/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.automessage;

import com.eternalcode.core.database.AbstractRepositoryOrmLite;
import com.eternalcode.core.database.DatabaseManager;
import com.eternalcode.core.feature.automessage.AutoMessageRepository;
import com.eternalcode.core.feature.automessage.AutoMessageTable;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Repository;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.libs.com.j256.ormlite.stmt.Where;
import com.eternalcode.core.libs.com.j256.ormlite.support.ConnectionSource;
import com.eternalcode.core.libs.com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Repository
class AutoMessageRepositoryOrmLite
extends AbstractRepositoryOrmLite
implements AutoMessageRepository {
    @Inject
    private AutoMessageRepositoryOrmLite(DatabaseManager databaseManager, Scheduler scheduler) throws SQLException {
        super(databaseManager, scheduler);
        TableUtils.createTableIfNotExists((ConnectionSource)databaseManager.connectionSource(), AutoMessageTable.class);
    }

    @Override
    public CompletableFuture<Set<UUID>> findReceivers(Set<UUID> onlineUniqueIds) {
        if (onlineUniqueIds.isEmpty()) {
            return CompletableFuture.completedFuture(onlineUniqueIds);
        }
        CompletableFuture tableList = this.action(AutoMessageTable.class, dao -> {
            Where where = dao.queryBuilder().where();
            where.in("unique_id", (Iterable)onlineUniqueIds);
            return where.query();
        });
        return tableList.thenApply(ignores -> {
            Set ignoredIds = ignores.stream().map(autoMessageTable -> autoMessageTable.uniqueId).collect(Collectors.toSet());
            return onlineUniqueIds.stream().filter(onlineUniqueId -> !ignoredIds.contains(onlineUniqueId)).collect(Collectors.toSet());
        });
    }

    @Override
    public CompletableFuture<Boolean> isReceiving(UUID uniqueId) {
        return this.selectSafe(AutoMessageTable.class, uniqueId).thenApply(Optional::isEmpty);
    }

    @Override
    public CompletableFuture<Boolean> switchReceiving(UUID uniqueId) {
        return this.selectSafe(AutoMessageTable.class, uniqueId).thenCompose(optional -> {
            if (optional.isEmpty()) {
                return this.save(AutoMessageTable.class, new AutoMessageTable(uniqueId)).thenApply(result -> false);
            }
            AutoMessageTable autoMessageTable = (AutoMessageTable)optional.get();
            return this.delete(AutoMessageTable.class, autoMessageTable).thenApply(state -> true);
        });
    }
}

