/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.afk;

import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.afk.Afk;
import com.eternalcode.core.feature.afk.AfkReason;
import com.eternalcode.core.feature.afk.AfkService;
import com.eternalcode.core.feature.afk.AfkSettings;
import com.eternalcode.core.feature.afk.event.AfkSwitchEvent;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

@Service
class AfkServiceImpl
implements AfkService {
    private final NoticeService noticeService;
    private final AfkSettings afkSettings;
    private final EventCaller eventCaller;
    private final Server server;
    private final Map<UUID, Afk> afkByPlayer = new HashMap<UUID, Afk>();
    private final Map<UUID, Integer> interactionsCount = new HashMap<UUID, Integer>();
    private final Map<UUID, Instant> lastInteraction = new HashMap<UUID, Instant>();

    @Inject
    public AfkServiceImpl(NoticeService noticeService, AfkSettings afkSettings, EventCaller eventCaller, Server server) {
        this.noticeService = noticeService;
        this.afkSettings = afkSettings;
        this.eventCaller = eventCaller;
        this.server = server;
    }

    @Override
    public void switchAfk(UUID playerUniqueId, AfkReason reason) {
        if (this.isAfk(playerUniqueId)) {
            this.clearAfk(playerUniqueId);
            return;
        }
        this.markAfk(playerUniqueId, reason);
    }

    @Override
    public Afk markAfk(UUID playerUniqueId, AfkReason reason) {
        Afk afk = new Afk(playerUniqueId, reason, Instant.now());
        AfkSwitchEvent event = this.eventCaller.callEvent(new AfkSwitchEvent(afk, true));
        if (event.isCancelled()) {
            return afk;
        }
        this.afkByPlayer.put(playerUniqueId, afk);
        this.sendAfkNotification(playerUniqueId, true);
        return afk;
    }

    @Override
    public Optional<Afk> getAfk(UUID playerUniqueId) {
        return Optional.ofNullable(this.afkByPlayer.get(playerUniqueId));
    }

    @Override
    public void markInteraction(UUID playerUniqueId) {
        this.lastInteraction.put(playerUniqueId, Instant.now());
        if (!this.isAfk(playerUniqueId)) {
            return;
        }
        int count = this.interactionsCount.getOrDefault(playerUniqueId, 0);
        if (++count >= this.afkSettings.interactionsCountDisableAfk()) {
            this.clearAfk(playerUniqueId);
            return;
        }
        this.interactionsCount.put(playerUniqueId, count);
    }

    @Override
    public void clearAfk(UUID playerUniqueId) {
        Afk afk = this.afkByPlayer.get(playerUniqueId);
        if (afk == null) {
            return;
        }
        AfkSwitchEvent event = this.eventCaller.callEvent(new AfkSwitchEvent(afk, false));
        if (event.isCancelled()) {
            return;
        }
        this.afkByPlayer.remove(playerUniqueId);
        this.interactionsCount.remove(playerUniqueId);
        this.lastInteraction.remove(playerUniqueId);
        this.sendAfkNotification(playerUniqueId, false);
    }

    @Override
    public boolean isAfk(UUID playerUniqueId) {
        return this.afkByPlayer.containsKey(playerUniqueId);
    }

    @ApiStatus.Internal
    boolean isInactive(UUID playerUniqueId) {
        Instant now = Instant.now();
        Instant lastMovement = this.lastInteraction.get(playerUniqueId);
        return lastMovement != null && Duration.between(lastMovement, now).compareTo(this.afkSettings.afkInactivityTime()) >= 0;
    }

    private void sendAfkNotification(UUID playerUniqueId, boolean afk) {
        Player player = this.server.getPlayer(playerUniqueId);
        if (player == null) {
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().onlinePlayers()).player(playerUniqueId)).notice(translation -> afk ? translation.afk().afkOn() : translation.afk().afkOff())).placeholder("{PLAYER}", player.getName())).send();
    }
}

