/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.configuration.serializer;

import com.eternalcode.core.libs.dev.rollczi.litecommands.reflect.ReflectUtil;
import com.eternalcode.core.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.eternalcode.core.libs.eu.okaeri.configs.serdes.SerializationData;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.bukkit.util.OldEnum;

public class OldEnumSerializer
implements ObjectSerializer<OldEnum<?>> {
    private static final Map<Class<?>, Method> VALUE_OF_METHODS = new HashMap();

    public boolean supports(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return OldEnum.class.isAssignableFrom(type);
    }

    public void serialize(OldEnum<?> object, SerializationData data, GenericsDeclaration generics) {
        data.setValue((Object)object.name());
    }

    public OldEnum<?> deserialize(DeserializationData data, GenericsDeclaration generics) {
        Class enumClass = generics.getType();
        String value = (String)data.getValue(String.class);
        try {
            Method valueOfMethod = VALUE_OF_METHODS.computeIfAbsent(enumClass, this::findValueOfMethod);
            return (OldEnum)ReflectUtil.invokeStaticMethod((Method)valueOfMethod, (Object[])new Object[]{value});
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot deserialize OldEnum", exception);
        }
    }

    private Method findValueOfMethod(Class<?> type) {
        Method valueOfMethod = ReflectUtil.getMethod(type, (String)"valueOf", (Class[])new Class[]{String.class});
        valueOfMethod.setAccessible(true);
        return valueOfMethod;
    }
}

