/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.paper;

import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import com.eternalcode.core.libs.io.papermc.lib.environments.Environment;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public abstract class PaperFeature {
    private static final Environment ENVIRONMENT = PaperLib.getEnvironment();
    private static final Logger LOGGER = Logger.getLogger("EternalCore-Paper");
    protected final Consumer<Player> action;
    protected final String featureName;

    protected PaperFeature(Consumer<Player> action, String featureName) {
        this.action = action;
        this.featureName = featureName;
    }

    public final void execute(Player player) {
        if (!ENVIRONMENT.isPaper()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "This feature is not supported on this server. Please contact the server administrator and check console!");
            LOGGER.warning("Feature '" + this.featureName + "' is only available on Paper or its 1.17.x+ forks");
            return;
        }
        this.action.accept(player);
    }
}

