/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.viewer;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.multification.viewer.ViewerProvider;
import com.eternalcode.core.user.User;
import com.eternalcode.core.user.UserManager;
import com.eternalcode.core.viewer.BukkitViewerImpl;
import com.eternalcode.core.viewer.Viewer;
import com.eternalcode.core.viewer.ViewerService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;

@Service
public class BukkitViewerProvider
implements ViewerProvider<Viewer>,
ViewerService {
    private final UserManager userManager;
    private final Server server;

    @Inject
    public BukkitViewerProvider(UserManager userManager, Server server) {
        this.userManager = userManager;
        this.server = server;
    }

    @Override
    public Collection<Viewer> all() {
        Collection<Viewer> audiences = this.onlinePlayers();
        audiences.add(this.console());
        return audiences;
    }

    @Override
    public Collection<Viewer> onlinePlayers() {
        Collection players = this.server.getOnlinePlayers();
        HashSet<Viewer> audiences = new HashSet<Viewer>(players.size());
        for (Player player : players) {
            audiences.add(this.player(player.getUniqueId()));
        }
        return audiences;
    }

    public Collection<Viewer> onlinePlayers(String permission) {
        Collection players = this.server.getOnlinePlayers();
        HashSet<Viewer> audiences = new HashSet<Viewer>(players.size());
        for (Player player : players) {
            if (!player.hasPermission(permission)) continue;
            audiences.add(this.player(player.getUniqueId()));
        }
        return audiences;
    }

    @Override
    public Viewer console() {
        return BukkitViewerImpl.console();
    }

    @Override
    public Viewer player(UUID uuid) {
        return this.userManager.getUser(uuid).map(Viewer.class::cast).orElseGet(() -> BukkitViewerImpl.player(uuid));
    }

    @Override
    public Viewer user(User user) {
        return BukkitViewerImpl.player(user.getUniqueId());
    }

    public Viewer sender(CommandSender commandSender) {
        return this.any(commandSender);
    }

    @Override
    public Viewer any(Object any) {
        if (any instanceof Player) {
            Player player = (Player)any;
            Optional<User> userOption = this.userManager.getUser(player.getUniqueId());
            if (userOption.isPresent()) {
                return userOption.get();
            }
            return BukkitViewerImpl.player(player.getUniqueId());
        }
        if (any instanceof ConsoleCommandSender || any instanceof RemoteConsoleCommandSender || any instanceof BlockCommandSender) {
            return BukkitViewerImpl.console();
        }
        throw new IllegalArgumentException("Unsupported sender type: " + any.getClass().getName());
    }
}

