/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.pom;

import com.eternalcode.core.loader.pom.XmlUtil;
import java.util.Properties;
import javax.annotation.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PomXmlProperties {
    private final Properties properties;

    private PomXmlProperties(Properties properties) {
        this.properties = properties;
    }

    static PomXmlProperties from(Element root) {
        Properties properties = new Properties();
        NodeList nodeList = (NodeList)((Object)XmlUtil.getChildNode(root, "properties"));
        if (nodeList == null) {
            return new PomXmlProperties(properties);
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String value;
            Node item = nodeList.item(i);
            if (!(item instanceof Element)) continue;
            Element element = (Element)item;
            String name = element.getNodeName();
            Node childWithValue = element.getFirstChild();
            if (childWithValue == null || (value = childWithValue.getNodeValue()) == null) continue;
            if (value.startsWith("[")) {
                value = value.substring(1, value.length() - 1);
            }
            properties.setProperty(name, value);
        }
        return new PomXmlProperties(properties);
    }

    @Nullable
    public String replaceProperties(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("${") && value.endsWith("}")) {
            String key = value.substring(2, value.length() - 1);
            return this.properties.getProperty(key);
        }
        return value;
    }
}

