/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.dependency;

import com.eternalcode.core.loader.dependency.Dependency;
import com.eternalcode.core.loader.dependency.DependencyException;
import com.eternalcode.core.loader.repository.Repository;
import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DependencyDownloader {
    private final Logger logger;
    private final Repository localRepository;
    private final List<Repository> repositories;

    public DependencyDownloader(Logger logger, Repository localRepository, List<Repository> repositories) {
        this.logger = logger;
        this.repositories = repositories;
        this.localRepository = localRepository;
    }

    public Path downloadDependency(Dependency dependency) {
        try {
            return this.tryDownloadDependency(dependency);
        }
        catch (URISyntaxException exception) {
            throw new DependencyException(exception);
        }
    }

    private Path tryDownloadDependency(Dependency dependency) throws URISyntaxException {
        Path localPath = dependency.toMavenJar(this.localRepository).toPath();
        if (Files.exists(localPath, new LinkOption[0])) {
            return localPath;
        }
        ArrayList<DependencyException> exceptions = new ArrayList<DependencyException>();
        for (Repository repository : this.repositories) {
            try {
                Path path = this.downloadJarAndSave(repository, dependency, localPath);
                this.logger.info("Downloaded " + String.valueOf(dependency) + " from " + String.valueOf(repository));
                return path;
            }
            catch (DependencyException exception) {
                exceptions.add(exception);
            }
        }
        DependencyException exception = new DependencyException("Failed to download dependency " + String.valueOf(dependency));
        for (DependencyException dependencyException : exceptions) {
            exception.addSuppressed(dependencyException);
        }
        throw exception;
    }

    private Path downloadJarAndSave(Repository repository, Dependency dependency, Path file) {
        try {
            byte[] bytes = this.downloadJar(repository, dependency);
            Path parent = file.getParent();
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.write(file, bytes, StandardOpenOption.CREATE);
        }
        catch (FileNotFoundException | NoSuchFileException fileNotFoundException) {
            throw new DependencyException("Dependency not found for repositoru: " + dependency.toMavenJar(repository).toString());
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
        return file;
    }

    private byte[] downloadJar(Repository repository, Dependency dependency) throws IOException {
        URLConnection connection = dependency.toMavenJar(repository).toURL().openConnection();
        try (InputStream in = connection.getInputStream();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            if (bytes.length == 0) {
                throw new IOException("Empty stream");
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

