/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand;

import com.eternalcode.core.injector.annotations.Bean;
import com.eternalcode.core.injector.annotations.component.Setup;
import com.eternalcode.core.injector.bean.BeanFactory;
import com.eternalcode.core.libs.dev.rollczi.litecommands.LiteCommands;
import com.eternalcode.core.libs.dev.rollczi.litecommands.LiteCommandsBuilder;
import com.eternalcode.core.libs.dev.rollczi.litecommands.adventure.bukkit.platform.LiteAdventurePlatformExtension;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.LiteCommandsAnnotations;
import com.eternalcode.core.libs.dev.rollczi.litecommands.bukkit.LiteBukkitFactory;
import com.eternalcode.core.libs.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.eternalcode.core.libs.dev.rollczi.litecommands.extension.LiteExtension;
import com.eternalcode.core.libs.dev.rollczi.litecommands.folia.FoliaExtension;
import com.eternalcode.core.libs.net.kyori.adventure.platform.AudienceProvider;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.libs.net.kyori.adventure.text.serializer.ComponentSerializer;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.publish.Subscribe;
import com.eternalcode.core.publish.event.EternalInitializeEvent;
import com.eternalcode.core.publish.event.EternalShutdownEvent;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@Setup
class LiteCommandsSetup {
    LiteCommandsSetup() {
    }

    @Bean
    public LiteCommandsBuilder<CommandSender, ?, ?> liteCommandsBuilder(Plugin plugin, Server server, AudienceProvider audiencesProvider, MiniMessage miniMessage, NoticeService noticeService, LiteCommandsAnnotations<CommandSender> liteCommandsAnnotations) {
        return LiteBukkitFactory.builder((String)"eternalcore", (Plugin)plugin, (Server)server).extension((LiteExtension)new FoliaExtension(plugin)).commands(liteCommandsAnnotations).message(LiteBukkitMessages.WORLD_NOT_EXIST, (invocation, world) -> (EternalCoreBroadcast)((EternalCoreBroadcast)noticeService.create().sender((CommandSender)invocation.sender()).notice(translation -> translation.argument().worldDoesntExist())).placeholder("{WORLD}", (String)world)).message(LiteBukkitMessages.LOCATION_INVALID_FORMAT, (invocation, input) -> (EternalCoreBroadcast)((EternalCoreBroadcast)noticeService.create().sender((CommandSender)invocation.sender()).notice(translation -> translation.argument().incorrectLocation())).placeholder("{LOCATION}", (String)input)).extension((LiteExtension)new LiteAdventurePlatformExtension(audiencesProvider), extension -> extension.serializer((ComponentSerializer)miniMessage));
    }

    @Bean
    public LiteCommandsAnnotations<CommandSender> liteCommandsAnnotations() {
        return LiteCommandsAnnotations.create();
    }

    @Subscribe(value=EternalInitializeEvent.class)
    public void onEnable(BeanFactory beanFactory, LiteCommandsBuilder<CommandSender, ?, ?> liteCommandsBuilder) {
        LiteCommands register = liteCommandsBuilder.build();
        beanFactory.addCandidate(LiteCommands.class, () -> register);
    }

    @Subscribe(value=EternalShutdownEvent.class)
    public void onShutdown(LiteCommands<CommandSender> liteCommands) {
        liteCommands.unregister();
    }
}

