/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.randomteleport;

import com.eternalcode.core.configuration.implementation.LocationsConfiguration;
import com.eternalcode.core.feature.randomteleport.RandomTeleportHeightRange;
import com.eternalcode.core.feature.randomteleport.RandomTeleportRadius;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.Position;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

@Service
class RandomTeleportSafeLocationService {
    private static final int DEFAULT_NETHER_HEIGHT = 125;
    private static final int NETHER_MAX_HEIGHT = 127;
    private final RandomTeleportSettings randomTeleportSettings;
    private final LocationsConfiguration locationsConfiguration;
    private final Random random = new Random();

    @Inject
    RandomTeleportSafeLocationService(RandomTeleportSettings randomTeleportSettings, LocationsConfiguration locationsConfiguration) {
        this.randomTeleportSettings = randomTeleportSettings;
        this.locationsConfiguration = locationsConfiguration;
    }

    public CompletableFuture<Location> getSafeRandomLocation(World world, RandomTeleportRadius radius, int attemptCount) {
        if (attemptCount < 0) {
            return CompletableFuture.failedFuture(new RuntimeException("Cannot find safe location"));
        }
        boolean noneWorld = this.locationsConfiguration.spawn.isNoneWorld();
        Location spawnLocation = !noneWorld ? PositionAdapter.convert((Position)this.locationsConfiguration.spawn) : world.getSpawnLocation();
        int spawnX = spawnLocation.getBlockX();
        int spawnZ = spawnLocation.getBlockZ();
        int randomX = spawnX + this.random.nextInt(radius.maxX() - radius.minX() + 1) + radius.minX();
        int randomZ = spawnZ + this.random.nextInt(radius.maxZ() - radius.minZ() + 1) + radius.minZ();
        return PaperLib.getChunkAtAsync((Location)new Location(world, (double)randomX, 100.0, (double)randomZ)).thenCompose(chunk -> {
            int randomY = chunk.getWorld().getHighestBlockYAt(randomX, randomZ);
            if (world.getEnvironment() == World.Environment.NETHER) {
                randomY = this.random.nextInt(125);
            }
            RandomTeleportHeightRange heightRange = this.randomTeleportSettings.heightRange();
            int minHeight = heightRange.getMinY();
            int maxHeight = heightRange.getMaxY() - 1;
            Location generatedLocation = new Location(world, (double)randomX, (double)(randomY = Math.min(Math.max(randomY, minHeight), maxHeight)), (double)randomZ).add(0.5, 1.0, 0.5);
            if (this.isSafeLocation((Chunk)chunk, generatedLocation)) {
                return CompletableFuture.completedFuture(generatedLocation);
            }
            return this.getSafeRandomLocation(world, radius, attemptCount - 1);
        });
    }

    private boolean isSafeLocation(Chunk chunk, Location location) {
        if (location.getWorld() == null) {
            return false;
        }
        World world = chunk.getWorld();
        Block block = world.getBlockAt(location);
        Block blockAbove = block.getRelative(BlockFace.UP);
        Block blockFloor = block.getRelative(BlockFace.DOWN);
        if (this.randomTeleportSettings.unsafeBlocks().contains(blockFloor.getType())) {
            return false;
        }
        Set<Material> airBlocks = this.randomTeleportSettings.airBlocks();
        if (!airBlocks.contains(block.getType()) || !airBlocks.contains(blockAbove.getType())) {
            return false;
        }
        if (!blockFloor.getType().isSolid()) {
            return false;
        }
        WorldBorder worldBorder = world.getWorldBorder();
        if (!worldBorder.isInside(location)) {
            return false;
        }
        return switch (world.getEnvironment()) {
            default -> throw new MatchException(null, null);
            case World.Environment.NORMAL, World.Environment.THE_END, World.Environment.CUSTOM -> true;
            case World.Environment.NETHER -> location.getY() <= 127.0;
        };
    }
}

