/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.deathmessage.handler;

import com.eternalcode.core.feature.deathmessage.DeathContext;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.RandomElementUtil;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

@Service
public class EnvironmentDeathMessageHandler {
    private final NoticeService noticeService;

    @Inject
    public EnvironmentDeathMessageHandler(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    public void handle(DeathContext context) {
        Player victim = context.victim();
        if (victim == null) {
            return;
        }
        String victimName = victim.getName();
        EntityDamageEvent.DamageCause cause = context.cause();
        if (context.deathType() == DeathContext.DeathType.ENTITY_KILL) {
            this.handleEntityKill(victim, context.damager());
            return;
        }
        if (cause != null) {
            this.handleEnvironmentDeath(victimName, cause);
            return;
        }
        this.handleUnknownDeath(victimName);
    }

    private void handleEntityKill(Player victim, Entity killer) {
        if (killer == null || !(killer instanceof LivingEntity)) {
            this.handleUnknownDeath(victim.getName());
            return;
        }
        String victimName = victim.getName();
        String mobName = this.getMobName(killer);
        EntityType mobType = killer.getType();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().noticeOptional(translation -> {
            List<Notice> mobMessages = translation.deathMessage().playerKilledByMobType().get(mobType);
            if (mobMessages != null && !mobMessages.isEmpty()) {
                return RandomElementUtil.randomElement(mobMessages);
            }
            List<Notice> genericMobMessages = translation.deathMessage().playerKilledByEntity();
            if (genericMobMessages != null && !genericMobMessages.isEmpty()) {
                return RandomElementUtil.randomElement(genericMobMessages);
            }
            return RandomElementUtil.randomElement(translation.deathMessage().playerDiedByUnknownCause());
        })).placeholder("{PLAYER}", victimName)).placeholder("{MOB}", mobName)).placeholder("{MOB_TYPE}", mobType.name())).onlinePlayers()).sendAsync();
    }

    private void handleEnvironmentDeath(String victimName, EntityDamageEvent.DamageCause cause) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().noticeOptional(translation -> {
            List<Notice> causeMessages = translation.deathMessage().playerDiedByDamageCause().get(cause);
            if (causeMessages != null && !causeMessages.isEmpty()) {
                return RandomElementUtil.randomElement(causeMessages);
            }
            return RandomElementUtil.randomElement(translation.deathMessage().playerDiedByUnknownCause());
        })).placeholder("{PLAYER}", victimName)).placeholder("{CAUSE}", this.formatCauseName(cause))).onlinePlayers()).sendAsync();
    }

    private void handleUnknownDeath(String victimName) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().noticeOptional(translation -> RandomElementUtil.randomElement(translation.deathMessage().playerDiedByUnknownCause()))).placeholder("{PLAYER}", victimName)).onlinePlayers()).sendAsync();
    }

    private String getMobName(Entity entity) {
        if (entity.getCustomName() != null) {
            return entity.getCustomName();
        }
        return this.formatEntityName(entity.getType());
    }

    private String formatName(String name) {
        String[] words = name.toLowerCase().replace("_", " ").split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }

    private String formatEntityName(EntityType type) {
        return this.formatName(type.name());
    }

    private String formatCauseName(EntityDamageEvent.DamageCause cause) {
        return this.formatName(cause.name());
    }
}

