/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.customcommand;

import com.eternalcode.core.configuration.AbstractConfigurationFile;
import com.eternalcode.core.feature.customcommand.CustomCommand;
import com.eternalcode.core.injector.annotations.component.ConfigurationFile;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Header;
import com.eternalcode.core.libs.net.kyori.adventure.bossbar.BossBar;
import java.io.File;
import java.time.Duration;
import java.util.List;

@ConfigurationFile
@Header(value={" ", "Custom commands configuration", "", "This file allows you to define your own commands using simple YAML configuration.", "Each command entry supports multiple display formats: chat, title, subtitle, action bar, bossbar and sound.", "", "Example usage:", "- Display your Discord link with a title and chat message (/discord)", "- Promote your store using a bossbar (/store)", "- Show server rules with a subtitle and timed title (/rules)", "", "You can test and generate these easily using:", "https://www.eternalcode.pl/notification-generator"})
public class CustomCommandConfig
extends AbstractConfigurationFile {
    @Comment(value={" ", "# Custom commands", "#", "# Each command defines its name, aliases and message configuration.", "#", "# WARNING: You must restart the server after editing this file for changes to take effect."})
    public List<CustomCommand> commands = List.of(CustomCommand.of("help", List.of("info"), ((Notice.Builder)((Notice.Builder)((Notice.Builder)((Notice.Builder)((Notice.Builder)Notice.builder().title("<rainbow>Welcome to EternalCore!</rainbow>")).subtitle("<gray>Use /help to get started</gray>")).times(Duration.ofMillis(500L), Duration.ofSeconds(3L), Duration.ofMillis(500L))).actionBar("<color:#9d6eef>Need support? Try /discord</color:#9d6eef>")).chat(new String[]{" ", "<yellow>To add your own commands, edit <aqua>custom-commands.yml</aqua> and restart the server.", "<gray>Use our generator to create nice looking messages:</gray>", "<aqua>https://www.eternalcode.pl/notification-generator</aqua>"})).build()), CustomCommand.of("discord", List.of("dc"), ((Notice.Builder)((Notice.Builder)((Notice.Builder)((Notice.Builder)Notice.builder().title("<blue>\ud83c\udfa7 Discord</blue>")).subtitle("<gray>Join the community!</gray>")).times(Duration.ofMillis(300L), Duration.ofSeconds(2L), Duration.ofMillis(300L))).chat(new String[]{" ", "<blue>\ud83c\udfa7 Join our Discord server:", "<aqua>https://discord.gg/yourserver</aqua>", " ", "<gray>Talk with the team, suggest features, get help.</gray>"})).build()), CustomCommand.of("store", List.of("shop"), ((Notice.Builder)((Notice.Builder)Notice.builder().bossBar(BossBar.Color.YELLOW, BossBar.Overlay.NOTCHED_10, Duration.ofSeconds(5L), 1.0, "<gold>\ud83d\uded2 Visit our store \u2013 support the server & get cool perks!")).chat(new String[]{" ", "<gold>\ud83d\uded2 Visit our server store:", "<aqua>https://store.yourserver.com</aqua>", " ", "<gray>Your support keeps us alive \u2764</gray>"})).build()), CustomCommand.of("vote", List.of("votes"), ((Notice.Builder)((Notice.Builder)Notice.builder().actionBar("<yellow>\u2605 Vote daily and earn rewards!</yellow>")).chat(new String[]{" ", "<yellow>\u2605 Vote for our server and receive daily rewards!", "<aqua>https://yourserver.com/vote</aqua>", " ", "<gray>Each vote helps us grow!</gray>"})).build()), CustomCommand.of("rules", List.of(), ((Notice.Builder)((Notice.Builder)((Notice.Builder)((Notice.Builder)((Notice.Builder)Notice.builder().title("<red>\ud83d\udcdc Server Rules</red>")).subtitle("<gray>Read before playing!</gray>")).times(Duration.ofMillis(300L), Duration.ofSeconds(3L), Duration.ofMillis(300L))).actionBar("<red>No cheating, griefing or toxicity \u2013 be respectful!</red>")).chat(new String[]{" ", "<red>\ud83d\udcdc Server Rules:", "<aqua>https://yourserver.com/rules</aqua>", " ", "<gray>Breaking rules may result in a ban.</gray>"})).build()), CustomCommand.of("map", List.of("dynmap"), ((Notice.Builder)Notice.builder().chat(new String[]{" ", "<color:#9d6eef>\ud83d\uddfa Live Server Map:", "<aqua>https://map.yourserver.com</aqua>", " ", "<gray>See what others are building in real time!</gray>"})).build()), CustomCommand.of("dom", List.of("chata"), ((Notice.Builder)Notice.builder().chat(new String[]{"<green>Teleportacja do domu...</green>"})).build(), List.of("home")));

    @Override
    public File getConfigFile(File dataFolder) {
        return new File(dataFolder, "custom-commands.yml");
    }
}

