/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.butcher;

import com.eternalcode.core.feature.butcher.MobType;
import com.eternalcode.core.util.EntityUtil;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Vehicle;

class MobEntity {
    private final MobType mobType;
    private Class<? extends Entity> entityClass;

    MobEntity(MobType mobType) {
        this.mobType = mobType;
    }

    MobEntity(MobType mobType, Class<? extends Entity> entityClass) {
        this.mobType = mobType;
        this.entityClass = entityClass;
    }

    boolean isMatch(Entity entity) {
        return switch (this.mobType) {
            default -> throw new MatchException(null, null);
            case MobType.PASSIVE -> EntityUtil.is(entity, Animals.class);
            case MobType.AGGRESSIVE -> EntityUtil.is(entity, Monster.class);
            case MobType.VEHICLE -> EntityUtil.is(entity, Vehicle.class);
            case MobType.ARMOR_STAND -> EntityUtil.is(entity, ArmorStand.class);
            case MobType.OTHER -> EntityUtil.is(entity, this.entityClass);
            case MobType.ALL -> EntityUtil.isMob(entity);
        };
    }
}

