/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.butcher;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.butcher.ButcherEntityRemoveEvent;
import com.eternalcode.core.feature.butcher.MobEntity;
import com.eternalcode.core.feature.butcher.MobFilter;
import com.eternalcode.core.feature.butcher.MobType;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Command(name="butcher", aliases={"killmob"})
@Permission(value={"eternalcore.butcher"})
class ButcherCommand {
    private final NoticeService noticeService;
    private final EventCaller eventCaller;

    @Inject
    ButcherCommand(NoticeService noticeService, EventCaller eventCaller) {
        this.noticeService = noticeService;
        this.eventCaller = eventCaller;
    }

    @Execute
    @DescriptionDocs(description={"Kills all mobs in 2 chunks around you"})
    void execute(@Sender Player player) {
        this.execute(player, 2);
    }

    @Execute
    @DescriptionDocs(description={"Kills all mobs in specified chunks around you"}, arguments={"<chunks>"})
    void execute(@Sender Player player, @Arg(value="chunks") int chunks) {
        this.execute(player, chunks, new MobEntity(MobType.ALL));
    }

    @Execute
    @DescriptionDocs(description={"Kills specified mob in specified chunks around you"}, arguments={"<chunks> <mobType>"})
    void execute(@Sender Player player, @Arg(value="chunks") int chunks, @Arg(value="mobType") MobEntity mobEntity) {
        this.killMobs(player, chunks, mobEntity::isMatch);
    }

    private void killMobs(Player player, int chunksNumber, MobFilter mobFilter) {
        Collection<Chunk> chunks = this.getChunksNearPlayer(player, chunksNumber);
        int killedMobs = 0;
        for (Chunk chunk : chunks) {
            for (Entity entity : chunk.getEntities()) {
                if (!mobFilter.filterMob(entity)) continue;
                ButcherEntityRemoveEvent event = new ButcherEntityRemoveEvent(entity);
                this.eventCaller.callEvent(event);
                if (event.isCancelled()) continue;
                entity.remove();
                ++killedMobs;
            }
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.butcher().killed())).player(player.getUniqueId())).placeholder("{KILLED}", String.valueOf(killedMobs))).send();
    }

    private Collection<Chunk> getChunksNearPlayer(Player player, int chunks) {
        Location location = player.getLocation();
        World world = player.getWorld();
        int chunkX = location.getBlockX() >> 4;
        int chunkZ = location.getBlockZ() >> 4;
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        for (int x = chunkX - chunks; x <= chunkX + chunks; ++x) {
            for (int z = chunkZ - chunks; z <= chunkZ + chunks; ++z) {
                chunkList.add(world.getChunkAt(x, z));
            }
        }
        return chunkList;
    }
}

