/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.afk;

import com.eternalcode.core.feature.afk.AfkReason;
import com.eternalcode.core.feature.afk.AfkService;
import com.eternalcode.core.feature.afk.AfkServiceImpl;
import com.eternalcode.core.feature.afk.AfkSettings;
import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Task;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Task(delay=1L, period=1L, unit=TimeUnit.MINUTES)
class AfkTask
implements Runnable {
    private final AfkService afkService;
    private final AfkServiceImpl afkServiceImpl;
    private final AfkSettings afkSettings;
    private final VanishService vanishService;
    private final Server server;

    @Inject
    public AfkTask(AfkService afkService, AfkServiceImpl afkServiceImpl, AfkSettings afkSettings, VanishService vanishService, Server server) {
        this.afkService = afkService;
        this.afkServiceImpl = afkServiceImpl;
        this.afkSettings = afkSettings;
        this.vanishService = vanishService;
        this.server = server;
    }

    @Override
    public void run() {
        this.markAllInactivePlayers();
    }

    void markAllInactivePlayers() {
        if (!this.afkSettings.autoAfk()) {
            return;
        }
        for (Player player : this.server.getOnlinePlayers()) {
            UUID playerUuid = player.getUniqueId();
            if (this.afkService.isAfk(playerUuid) || this.vanishService.isVanished(playerUuid) || !this.afkServiceImpl.isInactive(playerUuid)) continue;
            this.afkService.markAfk(playerUuid, AfkReason.INACTIVITY);
        }
    }
}

