/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.delay;

import com.eternalcode.core.libs.com.github.benmanes.caffeine.cache.Expiry;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

class InstantExpiry<T>
implements Expiry<T, Instant> {
    InstantExpiry() {
    }

    public long expireAfterCreate(@NotNull T key, @NotNull Instant expireTime, long currentTime) {
        return InstantExpiry.timeToExpire(expireTime);
    }

    public long expireAfterUpdate(@NotNull T key, @NotNull Instant newExpireTime, long currentTime, long currentDuration) {
        return InstantExpiry.timeToExpire(newExpireTime);
    }

    public long expireAfterRead(@NotNull T key, @NotNull Instant value, long currentTime, long currentDuration) {
        return currentDuration;
    }

    private static long timeToExpire(Instant expireTime) {
        Duration toExpire = Duration.between(Instant.now(), expireTime);
        if (toExpire.isNegative()) {
            return 0L;
        }
        long nanos = toExpire.toNanos();
        if (nanos == 0L) {
            return 1L;
        }
        return nanos;
    }
}

