/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.setslot;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.setslot.SetSlotService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.async.Async;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;

@Command(name="setslot")
@Permission(value={"eternalcore.setslot"})
public class SetSlotCommand {
    private final SetSlotService setSlotService;
    private final NoticeService noticeService;

    @Inject
    public SetSlotCommand(SetSlotService setSlotService, NoticeService noticeService) {
        this.setSlotService = setSlotService;
        this.noticeService = noticeService;
    }

    @Execute
    @Async
    @DescriptionDocs(description={"Set the max players on the server"})
    public void execute(@Sender Viewer viewer, @Arg int slots) {
        if (slots <= 0) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(notice -> notice.argument().numberBiggerThanOrEqualZero())).viewer(viewer)).send();
            return;
        }
        this.setSlotService.setCapacity(slots);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(notice -> notice.setSlot().slotSaved())).placeholder("{SLOTS}", String.valueOf(slots))).viewer(viewer)).send();
    }
}

